/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.WillCloseWhenClosed;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DirectoryBasedTestDefinition;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionConsumer;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestExecutor;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestExecutionListener;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

@NullMarked
public final class JUnitPlatformTestDefinitionProcessor
extends AbstractJUnitTestDefinitionProcessor<TestDefinition> {
    private final JUnitPlatformSpec spec;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final TestSelectionMatcher matcher;
    private @Nullable CollectThenExecuteTestDefinitionConsumer testClassExecutor;
    private @Nullable BackwardsCompatibleLauncherSession launcherSession;
    private @Nullable ClassLoader junitClassLoader;

    public JUnitPlatformTestDefinitionProcessor(JUnitPlatformSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super(actorFactory);
        this.spec = spec;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.matcher = new TestSelectionMatcher(spec.getFilter());
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.junit.platform.launcher.core.LauncherFactory");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestDefinitionProcessor.TestFrameworkNotAvailableException("Failed to load JUnit Platform.  Please ensure that all JUnit Platform dependencies are available on the test's runtime classpath, including the JUnit Platform launcher.");
        }
    }

    @Override
    protected TestDefinitionConsumer<TestDefinition> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)resultProcessorActor.getProxy(TestResultProcessor.class);
        this.launcherSession = BackwardsCompatibleLauncherSession.open();
        ClassLoader junitClassLoader = Thread.currentThread().getContextClassLoader();
        this.testClassExecutor = new CollectThenExecuteTestDefinitionConsumer(threadSafeResultProcessor, this.launcherSession, junitClassLoader, this.spec, this.idGenerator, this.clock);
        return this.testClassExecutor;
    }

    @Override
    public void stop() {
        if (this.startedProcessing) {
            Objects.requireNonNull(this.testClassExecutor).processAllTestClasses();
            Objects.requireNonNull(this.launcherSession).close();
            super.stop();
        }
    }

    @NullMarked
    private static final class BackwardsCompatibleLauncherSession
    implements AutoCloseable {
        private final Launcher launcher;
        private final Runnable onClose;

        static BackwardsCompatibleLauncherSession open() {
            try {
                LauncherSession launcherSession = LauncherFactory.openSession();
                return new BackwardsCompatibleLauncherSession(launcherSession);
            }
            catch (NoSuchMethodError ignore) {
                return new BackwardsCompatibleLauncherSession(LauncherFactory.create(), () -> {});
            }
        }

        BackwardsCompatibleLauncherSession(@WillCloseWhenClosed LauncherSession session) {
            this(session.getLauncher(), () -> ((LauncherSession)session).close());
        }

        BackwardsCompatibleLauncherSession(Launcher launcher, Runnable onClose) {
            this.launcher = launcher;
            this.onClose = onClose;
        }

        Launcher getLauncher() {
            return this.launcher;
        }

        @Override
        public void close() {
            this.onClose.run();
        }
    }

    @NullMarked
    private static final class CollectThenExecuteTestDefinitionConsumer
    implements TestDefinitionConsumer<TestDefinition> {
        private final List<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        private final TestResultProcessor resultProcessor;
        private final BackwardsCompatibleLauncherSession launcherSession;
        private final ClassLoader junitClassLoader;
        private final JUnitPlatformSpec spec;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;

        CollectThenExecuteTestDefinitionConsumer(TestResultProcessor resultProcessor, BackwardsCompatibleLauncherSession launcherSession, ClassLoader junitClassLoader, JUnitPlatformSpec spec, IdGenerator<?> idGenerator, Clock clock) {
            this.resultProcessor = resultProcessor;
            this.launcherSession = launcherSession;
            this.junitClassLoader = junitClassLoader;
            this.spec = spec;
            this.idGenerator = idGenerator;
            this.clock = clock;
        }

        @Override
        public void accept(TestDefinition testDefinition) {
            if (testDefinition instanceof ClassTestDefinition) {
                this.executeClass((ClassTestDefinition)testDefinition);
            } else if (testDefinition instanceof DirectoryBasedTestDefinition) {
                this.executeDirectory((DirectoryBasedTestDefinition)testDefinition);
            } else {
                throw new IllegalStateException("Unexpected test definition type " + testDefinition.getClass().getName());
            }
        }

        private void executeClass(ClassTestDefinition testDefinition) {
            Class<?> klass = this.loadClass(testDefinition.getTestClassName());
            if (this.isInnerClass(klass) || this.supportsVintageTests() && JUnitTestExecutor.isNestedClassInsideEnclosedRunner(klass)) {
                return;
            }
            this.selectors.add((DiscoverySelector)DiscoverySelectors.selectClass(klass));
        }

        private void executeDirectory(DirectoryBasedTestDefinition testDefinition) {
            this.selectors.add((DiscoverySelector)DiscoverySelectors.selectDirectory((File)testDefinition.getTestDefinitionsDir()));
        }

        private void processAllTestClasses() {
            LauncherDiscoveryRequest discoveryRequest = this.createLauncherDiscoveryRequest();
            JUnitPlatformTestExecutionListener executionListener = new JUnitPlatformTestExecutionListener(this.resultProcessor, this.clock, this.idGenerator);
            Launcher launcher = Objects.requireNonNull(this.launcherSession).getLauncher();
            if (this.spec.isDryRun()) {
                TestPlan testPlan = launcher.discover(discoveryRequest);
                this.executeDryRun(testPlan, executionListener);
            } else {
                launcher.execute(discoveryRequest, new TestExecutionListener[]{executionListener});
            }
        }

        private Class<?> loadClass(String className) {
            try {
                return Class.forName(className, false, this.junitClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private boolean isInnerClass(Class<?> klass) {
            return klass.getEnclosingClass() != null && !Modifier.isStatic(klass.getModifiers());
        }

        private boolean supportsVintageTests() {
            try {
                Class.forName("org.junit.vintage.engine.VintageTestEngine", false, this.junitClassLoader);
                Class.forName("org.junit.runner.Request", false, this.junitClassLoader);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private LauncherDiscoveryRequest createLauncherDiscoveryRequest() {
            LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().selectors(this.selectors);
            this.addTestNameFilters(requestBuilder);
            this.addEnginesFilter(requestBuilder);
            this.addTagsFilter(requestBuilder);
            return requestBuilder.build();
        }

        private void addTestNameFilters(LauncherDiscoveryRequestBuilder requestBuilder) {
            TestFilterSpec filter = this.spec.getFilter();
            if (this.isNotEmpty(filter)) {
                TestSelectionMatcher matcher = new TestSelectionMatcher(filter);
                requestBuilder.filters(new Filter[]{new ClassMethodNameFilter(matcher)});
            }
        }

        private void addEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
            List<String> excludeEngines;
            List<String> includeEngines = this.spec.getIncludeEngines();
            if (!includeEngines.isEmpty()) {
                requestBuilder.filters(new Filter[]{EngineFilter.includeEngines(includeEngines)});
            }
            if (!(excludeEngines = this.spec.getExcludeEngines()).isEmpty()) {
                requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines(excludeEngines)});
            }
        }

        private void addTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
            List<String> excludeTags;
            List<String> includeTags = this.spec.getIncludeTags();
            if (!includeTags.isEmpty()) {
                requestBuilder.filters(new Filter[]{TagFilter.includeTags(includeTags)});
            }
            if (!(excludeTags = this.spec.getExcludeTags()).isEmpty()) {
                requestBuilder.filters(new Filter[]{TagFilter.excludeTags(excludeTags)});
            }
        }

        private void executeDryRun(TestPlan testPlan, TestExecutionListener listener) {
            listener.testPlanExecutionStarted(testPlan);
            for (TestIdentifier root : testPlan.getRoots()) {
                this.dryRun(root, testPlan, listener);
            }
            listener.testPlanExecutionFinished(testPlan);
        }

        private void dryRun(TestIdentifier testIdentifier, TestPlan testPlan, TestExecutionListener listener) {
            if (testIdentifier.isTest()) {
                listener.executionSkipped(testIdentifier, "Gradle test execution dry run");
            } else {
                listener.executionStarted(testIdentifier);
                for (TestIdentifier child : testPlan.getChildren(testIdentifier)) {
                    this.dryRun(child, testPlan, listener);
                }
                listener.executionFinished(testIdentifier, TestExecutionResult.successful());
            }
        }

        private boolean isNotEmpty(TestFilterSpec filter) {
            return !filter.getIncludedTests().isEmpty() || !filter.getIncludedTestsCommandLine().isEmpty() || !filter.getExcludedTests().isEmpty();
        }
    }

    @NullMarked
    private static final class ClassMethodNameFilter
    implements PostDiscoveryFilter {
        private final TestSelectionMatcher matcher;

        private ClassMethodNameFilter(TestSelectionMatcher matcher) {
            this.matcher = matcher;
        }

        public FilterResult apply(TestDescriptor descriptor) {
            if (this.classMatch(descriptor)) {
                return FilterResult.included((String)"Class match");
            }
            return FilterResult.includedIf((boolean)this.shouldRun(descriptor), () -> "Method or class match", () -> "Method or class mismatch");
        }

        private boolean shouldRun(TestDescriptor descriptor) {
            return this.shouldRun(descriptor, false);
        }

        private boolean shouldRun(TestDescriptor descriptor, boolean checkingParent) {
            Optional source = descriptor.getSource();
            if (!source.isPresent()) {
                return true;
            }
            TestSource testSource = (TestSource)source.get();
            if (testSource instanceof MethodSource) {
                return this.shouldRun(descriptor, (MethodSource)testSource);
            }
            if (testSource instanceof ClassSource) {
                return this.shouldRun(descriptor, checkingParent, (ClassSource)testSource);
            }
            Optional parent = descriptor.getParent();
            return parent.isPresent() && this.shouldRun((TestDescriptor)parent.get(), true);
        }

        private boolean shouldRun(TestDescriptor descriptor, boolean checkingParent, ClassSource classSource) {
            Set children = descriptor.getChildren();
            if (!checkingParent) {
                for (TestDescriptor child : children) {
                    if (!this.shouldRun(child)) continue;
                    return true;
                }
            }
            if (children.isEmpty()) {
                String className = classSource.getClassName();
                return this.matcher.matchesTest(className, null) || this.matcher.matchesTest(className, descriptor.getLegacyReportingName());
            }
            return true;
        }

        private boolean shouldRun(TestDescriptor descriptor, MethodSource methodSource) {
            String methodName = methodSource.getMethodName();
            return this.matcher.matchesTest(methodSource.getClassName(), methodName) || this.matchesParentMethod(descriptor, methodName);
        }

        private boolean matchesParentMethod(TestDescriptor descriptor, String methodName) {
            return descriptor.getParent().flatMap(this::className).filter(className -> this.matcher.matchesTest(className, methodName)).isPresent();
        }

        private boolean classMatch(TestDescriptor descriptor) {
            Optional parent;
            TestDescriptor current = descriptor;
            String methodName = null;
            while ((parent = current.getParent()).isPresent()) {
                Optional<String> className = this.className(current);
                if (className.isPresent()) {
                    if (this.matcher.matchesTest(className.get(), methodName)) {
                        return true;
                    }
                    if (this.matcher.mayExcludeClass(className.get())) {
                        return false;
                    }
                }
                if (current.getSource().isPresent() && current.getSource().get() instanceof MethodSource) {
                    methodName = ((MethodSource)current.getSource().get()).getMethodName();
                }
                current = (TestDescriptor)parent.get();
            }
            return false;
        }

        private Optional<String> className(TestDescriptor descriptor) {
            return descriptor.getSource().filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getClassName);
        }
    }
}

