/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.plugins.ide.internal.tooling.model.PartialBasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;
import org.jspecify.annotations.NullMarked;

public class GradleBuildBuilder
implements BuildScopeModelBuilder {
    public static final String GRADLE_BUILD_MODEL_NAME = "org.gradle.tooling.model.gradle.GradleBuild";
    private final BuildStateRegistry buildStateRegistry;

    public GradleBuildBuilder(BuildStateRegistry buildStateRegistry) {
        this.buildStateRegistry = buildStateRegistry;
    }

    public boolean canBuild(String modelName) {
        return GRADLE_BUILD_MODEL_NAME.equals(modelName);
    }

    public DefaultGradleBuild create(BuildState target) {
        return new GradleBuildCreator(target).create();
    }

    protected static BasicGradleProject convert(BuildState owner, ProjectState project, Map<ProjectState, BasicGradleProject> convertedProjects) {
        DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getProjectPath().asString());
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getIdentityPath().asString()).setProjectDirectory(project.getProjectDir());
        if (project.getParent() != null) {
            converted.setParent(convertedProjects.get(project.getParent()));
        }
        convertedProjects.put(project, converted);
        for (ProjectState child : project.getChildProjects()) {
            converted.addChild(GradleBuildBuilder.convert(owner, child, convertedProjects));
        }
        return converted;
    }

    protected static void addProjects(BuildState target, DefaultGradleBuild model) {
        LinkedHashMap<ProjectState, BasicGradleProject> convertedProjects = new LinkedHashMap<ProjectState, BasicGradleProject>();
        ProjectState rootProject = target.getProjects().getRootProject();
        BasicGradleProject convertedRootProject = GradleBuildBuilder.convert(target, rootProject, convertedProjects);
        model.setRootProject(convertedRootProject);
        for (ProjectState project : target.getProjects().getAllProjects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
    }

    @NullMarked
    protected class GradleBuildCreator {
        private final BuildState target;
        private final Map<BuildState, DefaultGradleBuild> all = new LinkedHashMap<BuildState, DefaultGradleBuild>();

        GradleBuildCreator(BuildState target) {
            this.target = target;
        }

        DefaultGradleBuild create() {
            this.target.ensureProjectsLoaded();
            return this.convert(this.target);
        }

        protected DefaultGradleBuild convert(BuildState targetBuild) {
            DefaultGradleBuild model = this.all.get(targetBuild);
            if (model != null) {
                return model;
            }
            model = new DefaultGradleBuild();
            this.all.put(targetBuild, model);
            targetBuild.ensureProjectsLoaded();
            GradleInternal gradle = targetBuild.getMutableModel();
            GradleBuildBuilder.addProjects(targetBuild, model);
            this.addIncludedBuilds(gradle, model);
            this.addAllImportableBuilds(targetBuild, gradle, model);
            return model;
        }

        protected void addIncludedBuilds(GradleInternal gradle, DefaultGradleBuild model) {
            for (IncludedBuildInternal reference : gradle.includedBuilds()) {
                BuildState target = reference.getTarget();
                if (target instanceof IncludedBuildState || target instanceof RootBuildState) {
                    DefaultGradleBuild convertedIncludedBuild = this.convert(target);
                    model.addIncludedBuild(convertedIncludedBuild);
                    continue;
                }
                throw new IllegalStateException("Unknown build type: " + reference.getClass().getName());
            }
        }

        protected void addAllImportableBuilds(BuildState targetBuild, GradleInternal gradle, DefaultGradleBuild model) {
            if (gradle.getParent() == null) {
                ArrayList<DefaultGradleBuild> allBuilds = new ArrayList<DefaultGradleBuild>();
                GradleBuildBuilder.this.buildStateRegistry.visitBuilds(buildState -> {
                    if (buildState != targetBuild && buildState.isImportableBuild()) {
                        allBuilds.add(this.convert((BuildState)buildState));
                    }
                });
                model.addBuilds(allBuilds);
            }
        }
    }
}

