/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestDefinitionProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestDefinitionProcessorFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public abstract class JUnitPlatformTestFramework
implements TestFramework {
    private static final Logger LOGGER = Logging.getLogger(JUnitPlatformTestFramework.class);
    private final DefaultTestFilter filter;
    private final Provider<Boolean> dryRun;

    @Inject
    public JUnitPlatformTestFramework(DefaultTestFilter filter, Provider<Boolean> dryRun) {
        this.filter = filter;
        this.dryRun = dryRun;
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitPlatformTestFramework newTestFramework = (JUnitPlatformTestFramework)this.getObjectFactory().newInstance(JUnitPlatformTestFramework.class, new Object[]{newTestFilters, this.dryRun});
        newTestFramework.getOptions().copyFrom(this.getOptions());
        return newTestFramework;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Override
    public WorkerTestDefinitionProcessorFactory<?> getProcessorFactory() {
        this.validateOptions();
        return new JUnitPlatformTestDefinitionProcessorFactory(new JUnitPlatformSpec(this.filter.toSpec(), this.getOptions().getIncludeEngines(), this.getOptions().getExcludeEngines(), this.getOptions().getIncludeTags(), this.getOptions().getExcludeTags(), ((Boolean)this.dryRun.get()).booleanValue()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
    }

    @Override
    @Nested
    public abstract JUnitPlatformOptions getOptions();

    @Override
    public TestFrameworkDetector getDetector() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    private void validateOptions() {
        HashSet intersection = Sets.newHashSet(this.getOptions().getIncludeTags());
        intersection.retainAll(this.getOptions().getExcludeTags());
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                LOGGER.warn("The tag '" + (String)intersection.iterator().next() + "' is both included and excluded.  This will result in the tag being excluded, which may not be what was intended.  Please either include or exclude the tag but not both.");
            } else {
                String allTags = intersection.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
                LOGGER.warn("The tags " + allTags + " are both included and excluded.  This will result in the tags being excluded, which may not be what was intended.  Please either include or exclude the tags but not both.");
            }
        }
    }

    @Override
    public boolean supportsNonClassBasedTesting() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "JUnit Platform";
    }
}

