/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.DelegatingFileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.impl.PatternSetSnapshottingFilter;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileSystemAccess fileSystemAccess;
    private final Stat stat;

    public DefaultFileCollectionSnapshotter(FileSystemAccess fileSystemAccess, Stat stat) {
        this.fileSystemAccess = fileSystemAccess;
        this.stat = stat;
    }

    public FileSystemSnapshot snapshot(FileCollection fileCollection, FileCollectionStructureVisitor visitor) {
        SnapshottingVisitor snapshottingVisitor = new SnapshottingVisitor(visitor);
        ((FileCollectionInternal)fileCollection).visitStructure((FileCollectionStructureVisitor)snapshottingVisitor);
        return CompositeFileSystemSnapshot.of(snapshottingVisitor.getRoots());
    }

    private class SnapshottingVisitor
    extends DelegatingFileCollectionStructureVisitor {
        private final List<FileSystemSnapshot> roots;

        private SnapshottingVisitor(FileCollectionStructureVisitor delegate) {
            super(delegate);
            this.roots = new ArrayList<FileSystemSnapshot>();
        }

        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            super.visitCollection(source, contents);
            for (File file : contents) {
                this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(file.getAbsolutePath()));
            }
        }

        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            super.visitFileTree(root, patterns, fileTree);
            DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(root.getAbsolutePath(), (SnapshottingFilter)new PatternSetSnapshottingFilter(patterns, DefaultFileCollectionSnapshotter.this.stat)).ifPresent(this.roots::add);
        }

        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            super.visitFileTreeBackedByFile(file, fileTree, sourceTree);
            this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(file.getAbsolutePath()));
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

