/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.Objects;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionConsumer;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public abstract class AbstractJUnitTestClassProcessor<D extends TestDefinition>
implements RequiresTestFrameworkTestClassProcessor<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJUnitTestClassProcessor.class);
    private final ActorFactory actorFactory;
    private @Nullable Actor resultProcessorActor;
    private @Nullable TestDefinitionConsumer<D> executor;
    protected boolean startedProcessing;

    public AbstractJUnitTestClassProcessor(ActorFactory actorFactory) {
        this.actorFactory = actorFactory;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.assertTestFrameworkAvailable();
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)resultProcessor);
        this.executor = this.createTestExecutor(this.resultProcessorActor);
        this.startedProcessing = true;
    }

    protected abstract TestDefinitionConsumer<D> createTestExecutor(Actor var1);

    public final void processTestDefinition(D testDefinition) {
        if (this.startedProcessing) {
            LOGGER.debug("Executing {}", (Object)testDefinition.getDisplayName());
            Objects.requireNonNull(this.executor).accept(testDefinition);
        }
    }

    public void stop() {
        if (this.startedProcessing) {
            this.resultProcessorActor.stop();
        }
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

