/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DirectoryBasedTestDefinition;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;

public class RunPreviousFailedFirstTestClassProcessor<D extends TestDefinition>
implements TestClassProcessor<D> {
    private final Set<String> previousFailedTestClasses;
    private final Set<File> previousFailedTestDefinitionDirectories;
    private final TestClassProcessor<D> delegate;
    private final LinkedHashSet<D> prioritizedTestDefinitions = new LinkedHashSet();
    private final LinkedHashSet<D> otherTestDefinitions = new LinkedHashSet();

    public RunPreviousFailedFirstTestClassProcessor(Set<String> previousFailedTestClasses, Set<File> previousFailedTestDefinitionDirectories, TestClassProcessor<D> delegate) {
        this.previousFailedTestClasses = previousFailedTestClasses;
        this.previousFailedTestDefinitionDirectories = previousFailedTestDefinitionDirectories;
        this.delegate = delegate;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.delegate.startProcessing(resultProcessor);
    }

    public void processTestDefinition(D testDefinition) {
        if (this.wasPreviouslyRun((TestDefinition)testDefinition)) {
            this.prioritizedTestDefinitions.add(testDefinition);
        } else {
            this.otherTestDefinitions.add(testDefinition);
        }
    }

    public void stop() {
        for (TestDefinition test : this.prioritizedTestDefinitions) {
            this.delegate.processTestDefinition(test);
        }
        for (TestDefinition test : this.otherTestDefinitions) {
            this.delegate.processTestDefinition(test);
        }
        this.delegate.stop();
    }

    public void stopNow() {
        this.delegate.stopNow();
    }

    private boolean wasPreviouslyRun(TestDefinition testDefinition) {
        if (testDefinition instanceof ClassTestDefinition) {
            return this.previousFailedTestClasses.contains(((ClassTestDefinition)testDefinition).getTestClassName());
        }
        if (testDefinition instanceof DirectoryBasedTestDefinition) {
            return this.previousFailedTestDefinitionDirectories.contains(((DirectoryBasedTestDefinition)testDefinition).getTestDefinitionsDir());
        }
        throw new IllegalStateException("Unexpected test definition type " + testDefinition.getClass().getName());
    }
}

