/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.function.LongFunction;
import org.gradle.api.internal.exceptions.MarkedVerificationException;
import org.gradle.api.internal.tasks.testing.DefaultGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.TestResultState;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class DefaultRootTestEventReporter
extends DefaultGroupTestEventReporter {
    private final Path binaryResultsDir;
    private final SerializableTestResultStore.Writer testResultWriter;
    private final @Nullable TestReportGenerator testReportGenerator;
    private final TestExecutionResultsListener executionResultsListener;
    private final boolean closeThrowsOnTestFailures;
    private @Nullable String failureMessage;

    DefaultRootTestEventReporter(LongFunction<TestDescriptorInternal> rootDescriptorFactory, TestListenerInternal listener, IdGenerator<Long> idGenerator, Path binaryResultsDir, SerializableTestResultStore.Writer testResultWriter, @Nullable TestReportGenerator testReportGenerator, TestExecutionResultsListener executionResultsListener, boolean closeThrowsOnTestFailures) {
        super(listener, idGenerator, rootDescriptorFactory.apply((Long)idGenerator.generateId()), new TestResultState(null));
        this.binaryResultsDir = binaryResultsDir;
        this.testResultWriter = testResultWriter;
        this.testReportGenerator = testReportGenerator;
        this.executionResultsListener = executionResultsListener;
        this.closeThrowsOnTestFailures = closeThrowsOnTestFailures;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Throwable t) {
            try {
                this.testResultWriter.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
        try {
            this.testResultWriter.close();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        Path reportIndexFile = this.testReportGenerator == null ? null : this.testReportGenerator.generate(Collections.singletonList(this.binaryResultsDir));
        boolean hasTestFailures = this.failureMessage != null;
        this.executionResultsListener.executionResultsAvailable(this.testDescriptor, this.binaryResultsDir, hasTestFailures);
        if (hasTestFailures && this.closeThrowsOnTestFailures) {
            if (reportIndexFile == null) {
                throw new MarkedVerificationException(this.failureMessage);
            }
            String testResultsUrl = new ConsoleRenderer().asClickableFileUrl(reportIndexFile.toFile());
            throw new MarkedVerificationException(this.failureMessage + " See the report at: " + testResultsUrl);
        }
    }

    @Override
    public void failed(Instant endTime, String message, String additionalContent) {
        this.failureMessage = TextUtil.isBlank((String)message) ? "Test(s) failed." : message;
        super.failed(endTime, message, additionalContent);
    }
}

