/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeEntry;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.AttributeValueIsolator;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesContainer;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesEntry;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.HierarchicalMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.attributes.UsageCompatibilityHandler;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.jspecify.annotations.Nullable;

public final class DefaultAttributesFactory
implements AttributesFactory {
    private static final ImmutableAttributes ROOT = ImmutableAttributes.EMPTY;
    private final AttributeValueIsolator attributeValueIsolator;
    private final PropertyFactory propertyFactory;
    private final UsageCompatibilityHandler usageCompatibilityHandler;
    private final NamedObjectInstantiator instantiator;
    private final Map<ImmutableAttributes, ImmutableList<ImmutableAttributes>> concatCache;

    public DefaultAttributesFactory(AttributeValueIsolator attributeValueIsolator, IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator, PropertyFactory propertyFactory) {
        this.attributeValueIsolator = attributeValueIsolator;
        this.propertyFactory = propertyFactory;
        this.usageCompatibilityHandler = new UsageCompatibilityHandler(isolatableFactory, instantiator);
        this.concatCache = new ConcurrentHashMap<ImmutableAttributes, ImmutableList<ImmutableAttributes>>();
        this.instantiator = instantiator;
    }

    @Override
    public AttributeContainerInternal mutable() {
        return new DefaultMutableAttributeContainer(this, this.attributeValueIsolator, this.instantiator, this.propertyFactory);
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal fallback) {
        return this.join(fallback, this.mutable());
    }

    @Override
    public AttributeContainerInternal join(AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        return new HierarchicalMutableAttributeContainer(this, fallback, primary);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.concat(ROOT, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        return this.concat(node, key, this.attributeValueIsolator.isolate(value));
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        if (key.equals((Object)Usage.USAGE_ATTRIBUTE) || key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) {
            return this.usageCompatibilityHandler.doConcat(this, node, key, value);
        }
        return this.doConcatEntry(node, new DefaultImmutableAttributesEntry<T>(key, value));
    }

    <T> ImmutableAttributes doConcatEntry(ImmutableAttributes node, ImmutableAttributesEntry<T> entry) {
        ImmutableAttributes child;
        this.assertAttributeNotAlreadyPresent(node, entry.getKey());
        ImmutableList cachedChildren = this.concatCache.get(node);
        if (cachedChildren != null && (child = DefaultAttributesFactory.findChild(cachedChildren, entry)) != null) {
            return child;
        }
        cachedChildren = this.concatCache.compute(node, (k, nodeChildren) -> {
            ImmutableAttributes child;
            if (nodeChildren != null) {
                child = DefaultAttributesFactory.findChild((ImmutableList<ImmutableAttributes>)nodeChildren, entry);
                if (child != null) {
                    return nodeChildren;
                }
            } else {
                nodeChildren = ImmutableList.of();
            }
            child = new DefaultImmutableAttributesContainer(node, entry);
            return DefaultAttributesFactory.concatChild((ImmutableList<ImmutableAttributes>)nodeChildren, child);
        });
        return Objects.requireNonNull(DefaultAttributesFactory.findChild((ImmutableList<ImmutableAttributes>)cachedChildren, entry));
    }

    private static @Nullable ImmutableAttributes findChild(ImmutableList<ImmutableAttributes> nodeChildren, ImmutableAttributesEntry<?> entry) {
        for (ImmutableAttributes child : nodeChildren) {
            ImmutableAttributesEntry<?> headEntry = child.getHead();
            if (!headEntry.getKey().equals(entry.getKey()) || !headEntry.getValue().equals(entry.getValue())) continue;
            return child;
        }
        return null;
    }

    private static ImmutableList<ImmutableAttributes> concatChild(ImmutableList<ImmutableAttributes> nodeChildren, ImmutableAttributes child) {
        return ImmutableList.builderWithExpectedSize((int)(nodeChildren.size() + 1)).addAll(nodeChildren).add((Object)child).build();
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes fallback, ImmutableAttributes primary) {
        if (fallback == ImmutableAttributes.EMPTY) {
            return primary;
        }
        if (primary == ImmutableAttributes.EMPTY) {
            return fallback;
        }
        ImmutableAttributes current = primary;
        for (ImmutableAttributesEntry toConcat : fallback.getEntries()) {
            if (current.findEntry(toConcat.getKey().getName()) != null) continue;
            current = this.doConcatEntry(current, toConcat);
        }
        return current;
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        if (attributes1 == ImmutableAttributes.EMPTY) {
            return attributes2;
        }
        if (attributes2 == ImmutableAttributes.EMPTY) {
            return attributes1;
        }
        ImmutableAttributes current = attributes2;
        for (ImmutableAttributesEntry toConcat : attributes1.getEntries()) {
            ImmutableAttributesEntry<?> existing = current.findEntry(toConcat.getKey().getName());
            if (existing != null && !toConcat.getIsolatedValue().equals(existing.getIsolatedValue())) {
                Attribute attribute = toConcat.getKey();
                String message = "An attribute named '" + attribute.getName() + "' of type '" + attribute.getType().getName() + "' already exists in this container";
                throw new AttributeMergingException(attribute, toConcat.getIsolatedValue(), existing.getIsolatedValue(), message);
            }
            current = this.doConcatEntry(current, toConcat);
        }
        return current;
    }

    @Override
    public ImmutableAttributes fromEntries(Collection<AttributeEntry<?>> entries) {
        ImmutableAttributes result = ImmutableAttributes.EMPTY;
        for (AttributeEntry<?> entry : entries) {
            result = this.concatEntry(result, entry);
        }
        return result;
    }

    private <T> ImmutableAttributes concatEntry(ImmutableAttributes attributes, AttributeEntry<T> entry) {
        return this.concat(attributes, entry.getKey(), entry.getValue());
    }

    void assertAttributeNotAlreadyPresent(ImmutableAttributes container, Attribute<?> key) {
        ImmutableAttributesEntry<?> entry = container.findEntry(key.getName());
        if (entry != null && entry.getKey().getType() != key.getType()) {
            throw new IllegalArgumentException(this.buildSameNameDifferentTypeErrorMsg(key, entry.getKey()));
        }
    }

    private String buildSameNameDifferentTypeErrorMsg(Attribute<?> newAttribute, Attribute<?> oldAttribute) {
        return "Cannot have two attributes with the same name but different types. This container already has an attribute named '" + newAttribute.getName() + "' of type '" + oldAttribute.getType().getName() + "' and you are trying to store another one of type '" + newAttribute.getType().getName() + "'";
    }
}

