/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.jspecify.annotations.Nullable;

public class BrokenBuildsCapturingListener
implements BuildIncludeListener {
    private final FailureFactory failureFactory;
    private final Map<BuildState, Failure> brokenBuilds = new HashMap<BuildState, Failure>();
    private final Map<SettingsInternal, Failure> brokenSettings = new HashMap<SettingsInternal, Failure>();

    public BrokenBuildsCapturingListener(FailureFactory failureFactory) {
        this.failureFactory = failureFactory;
    }

    @Override
    public void buildInclusionFailed(BuildState buildState, @Nullable Exception exception) {
        Failure failure = this.failureFactory.create((Throwable)exception);
        this.brokenBuilds.put(buildState, failure);
    }

    @Override
    public Map<BuildState, Failure> getBrokenBuilds() {
        return this.brokenBuilds;
    }

    @Override
    public void settingsScriptFailed(SettingsInternal settingsScript, LocationAwareException e) {
        this.getBrokenSettings().put(settingsScript, this.failureFactory.create((Throwable)((Object)e)));
    }

    @Override
    public Map<SettingsInternal, Failure> getBrokenSettings() {
        return this.brokenSettings;
    }
}

