/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Utf8;
import com.google.common.collect.Streams;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.io.FileSystem;
import org.gradle.api.GradleException;

public final class SafeFileLocationUtils {
    public static final int WINDOWS_PATH_LIMIT = 260;
    private static final HashFunction HASHER = Hashing.sipHash24();
    private static final BaseEncoding BASE_ENCODING = BaseEncoding.base32Hex().omitPadding();
    private static final byte[] TRUNCATED_PREFIX_BYTES = "_cut_".getBytes(StandardCharsets.UTF_8);
    private static final int MAX_FILE_NAME_LENGTH_IN_BYTES = 255;
    @VisibleForTesting
    static final int MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES = 255 - TRUNCATED_PREFIX_BYTES.length - 1 - (HASHER.bits() + 4) / 5;
    private static final CharBuffer ILLEGAL_CHAR_REPLACEMENT = CharBuffer.wrap("-");
    private static final int[] INVALID_CODE_POINTS = Streams.concat((IntStream[])new IntStream[]{IntStream.of(FileSystem.GENERIC.getIllegalFileNameCodePoints()), IntStream.of(FileSystem.LINUX.getIllegalFileNameCodePoints()), IntStream.of(FileSystem.MAC_OSX.getIllegalFileNameCodePoints()), IntStream.of(FileSystem.WINDOWS.getIllegalFileNameCodePoints()), IntStream.of(32, 9, 10, 13)}).distinct().sorted().toArray();
    private static final ThreadLocal<CharsetEncoder> REPORTING_UTF_8_ENCODER = ThreadLocal.withInitial(() -> StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));

    private static boolean isInvalidCodePoint(int codePoint) {
        int type = Character.getType(codePoint);
        if (type == 15 || type == 18 || type == 19 || type == 0) {
            return true;
        }
        return Arrays.binarySearch(INVALID_CODE_POINTS, codePoint) >= 0;
    }

    public static String toSafeFileName(String name) {
        Utf8EncodingResult nameResult;
        try {
            nameResult = SafeFileLocationUtils.encodeIntoUtf8WithReplacement(name);
        }
        catch (CharacterCodingException e) {
            throw new AssertionError("Unexpected encoding error, should have filtered invalid input", e);
        }
        if (nameResult.cleanBytes.length <= MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES) {
            return nameResult.getCleanString();
        }
        byte[] hashBytes = HASHER.hashUnencodedChars((CharSequence)name).asBytes();
        String encoded = BASE_ENCODING.encode(hashBytes);
        return SafeFileLocationUtils.shortenNameAndAddHash(nameResult.cleanBytes, encoded);
    }

    private static Utf8EncodingResult encodeIntoUtf8WithReplacement(String original) throws CharacterCodingException {
        int charCount;
        CharsetEncoder encoder = REPORTING_UTF_8_ENCODER.get().reset();
        ByteBuffer result = ByteBuffer.allocate((int)((float)original.length() * encoder.averageBytesPerChar()));
        boolean hadIllegalChars = false;
        for (int i = 0; i < original.length(); i += charCount) {
            boolean endOfInput;
            int codePoint = original.codePointAt(i);
            charCount = Character.charCount(codePoint);
            boolean bl = endOfInput = i + charCount >= original.length();
            if (SafeFileLocationUtils.isInvalidCodePoint(codePoint)) {
                hadIllegalChars = true;
                result = SafeFileLocationUtils.doEncode(encoder, ILLEGAL_CHAR_REPLACEMENT.duplicate(), result, endOfInput);
                continue;
            }
            result = SafeFileLocationUtils.doEncode(encoder, CharBuffer.wrap(original, i, i + charCount), result, endOfInput);
        }
        byte[] cleanBytes = Arrays.copyOf(result.array(), result.position());
        return new Utf8EncodingResult(original, hadIllegalChars, cleanBytes);
    }

    private static ByteBuffer doEncode(CharsetEncoder encoder, CharBuffer source, ByteBuffer result, boolean endOfInput) throws CharacterCodingException {
        while (source.hasRemaining()) {
            CoderResult encodeResult = encoder.encode(source, result, endOfInput);
            if (encodeResult.isOverflow()) {
                result = SafeFileLocationUtils.reallocateBuffer(result);
                continue;
            }
            if (encodeResult.isUnderflow()) break;
            encodeResult.throwException();
        }
        if (endOfInput) {
            while (true) {
                CoderResult flushResult;
                if ((flushResult = encoder.flush(result)).isOverflow()) {
                    result = SafeFileLocationUtils.reallocateBuffer(result);
                    continue;
                }
                if (flushResult.isUnderflow()) break;
                flushResult.throwException();
            }
        }
        return result;
    }

    private static ByteBuffer reallocateBuffer(ByteBuffer result) {
        ByteBuffer newResult = ByteBuffer.allocate(result.capacity() * 2);
        result.flip();
        newResult.put(result);
        return newResult;
    }

    private static String shortenNameAndAddHash(byte[] rawName, String encoded) {
        int safeLength;
        ByteBuffer result = ByteBuffer.allocate(255);
        byte[] extensions = null;
        int firstDot = SafeFileLocationUtils.findStartOfExtension(rawName);
        if (firstDot > 0) {
            extensions = Arrays.copyOfRange(rawName, firstDot, rawName.length);
            safeLength = SafeFileLocationUtils.getSafeLength(rawName, MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES - extensions.length);
        } else {
            safeLength = SafeFileLocationUtils.getSafeLength(rawName, MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES);
        }
        result.put(TRUNCATED_PREFIX_BYTES);
        result.put(rawName, 0, safeLength);
        result.put((byte)45);
        byte[] encodedBytes = encoded.getBytes(StandardCharsets.US_ASCII);
        result.put(encodedBytes);
        if (extensions != null) {
            result.put(extensions);
        }
        return new String(result.array(), 0, result.position(), StandardCharsets.UTF_8);
    }

    private static int findStartOfExtension(byte[] rawName) {
        int start;
        for (int i = start = Math.max(1, rawName.length - (MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES - 1)); i < rawName.length - 1; ++i) {
            if (rawName[i] != 46) continue;
            return i;
        }
        return -1;
    }

    private static int getSafeLength(byte[] rawName, int maxBytes) {
        int startOfCodePoint;
        if (rawName.length <= maxBytes) {
            return rawName.length;
        }
        for (startOfCodePoint = maxBytes - 1; startOfCodePoint > 0 && (rawName[startOfCodePoint] & 0xC0) == 128; --startOfCodePoint) {
        }
        if (Utf8.isWellFormed((byte[])rawName, (int)startOfCodePoint, (int)(maxBytes - startOfCodePoint))) {
            return maxBytes;
        }
        return startOfCodePoint;
    }

    public static File assertInWindowsPathLengthLimitation(File file) {
        if (file.getAbsolutePath().length() > 260) {
            throw new GradleException(String.format("Cannot create file. '%s' exceeds windows path limitation of %d character.", file.getAbsolutePath(), 260));
        }
        return file;
    }

    private static final class Utf8EncodingResult {
        private final String original;
        private final boolean hadIllegalChars;
        private final byte[] cleanBytes;

        public Utf8EncodingResult(String original, boolean hadIllegalChars, byte[] cleanBytes) {
            this.original = original;
            this.hadIllegalChars = hadIllegalChars;
            this.cleanBytes = cleanBytes;
        }

        public String getCleanString() {
            return this.hadIllegalChars ? new String(this.cleanBytes, StandardCharsets.UTF_8) : this.original;
        }
    }
}

