/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.base.Throwables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.input.NullReader;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ExceptionSerializationUtil;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class SerializableTestResultStore {
    private static final int STORE_VERSION = 1;
    private final Path serializedResultsFile;
    private final Path outputZipFile;

    public SerializableTestResultStore(Path resultsDir) {
        this.serializedResultsFile = resultsDir.resolve("results-generic.bin");
        this.outputZipFile = resultsDir.resolve("output-generic.zip");
    }

    public Writer openWriter(int diskSkipLevels) throws IOException {
        return new Writer(this.serializedResultsFile, this.outputZipFile, diskSkipLevels);
    }

    public boolean hasResults() {
        if (Files.exists(this.serializedResultsFile, new LinkOption[0]) && Files.exists(this.outputZipFile, new LinkOption[0])) {
            boolean bl;
            block9: {
                KryoBackedDecoder decoder = this.openAndInitializeDecoder();
                try {
                    boolean bl2 = bl = decoder.readSmallLong() != 0L;
                    if (decoder == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (decoder != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                decoder.close();
            }
            return bl;
        }
        return false;
    }

    public void forEachResult(Consumer<? super OutputTrackedResult> action) throws IOException {
        try (KryoBackedDecoder resultsDecoder = this.openAndInitializeDecoder();){
            long id;
            while ((id = resultsDecoder.readSmallLong()) != 0L) {
                if (id < 0L) {
                    throw new IllegalStateException("Invalid id: " + id);
                }
                SerializableTestResult testResult = SerializableTestResult.Serializer.deserialize((Decoder)resultsDecoder);
                long parentId = resultsDecoder.readSmallLong();
                if (parentId < 0L) {
                    throw new IllegalStateException("Invalid parent id: " + parentId);
                }
                action.accept(new OutputTrackedResult(id, testResult, parentId));
            }
        }
    }

    private KryoBackedDecoder openAndInitializeDecoder() throws IOException {
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(this.serializedResultsFile, new OpenOption[0]));
        try {
            int version = decoder.readSmallInt();
            if (version != 1) {
                throw new IOException("Unsupported version: " + version);
            }
        }
        catch (Throwable t) {
            try {
                decoder.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return decoder;
    }

    public OutputReader openOutputReader() throws IOException {
        return new OutputReader(this.outputZipFile);
    }

    @NullMarked
    public static final class Writer
    implements Closeable,
    TestListenerInternal {
        private static final long ROOT_ID = 1L;
        private final Map<Object, Long> assignedIds = new HashMap<Object, Long>();
        private final Set<Object> flatteningIds;
        private final List<TestDescriptorInternal> extraFlattenedDescriptors;
        private final List<TestResult> extraFlattenedResults;
        private final Path serializedResultsFile;
        private final int diskSkipLevels;
        private final Path temporaryResultsFile;
        private final KryoBackedEncoder resultsEncoder;
        private final FileSystem outputZipFileSystem;
        private long nextId = 1L;
        private final Multimap<TestDescriptorInternal, SerializedMetadata> metadatas = LinkedHashMultimap.create();

        private static boolean isRoot(TestDescriptorInternal descriptor) {
            return descriptor.getParent() == null;
        }

        private static int depth(TestDescriptorInternal descriptor) {
            int depth = 0;
            while (descriptor.getParent() != null) {
                ++depth;
                descriptor = descriptor.getParent();
            }
            return depth;
        }

        private Writer(Path serializedResultsFile, Path outputZipFile, int diskSkipLevels) throws IOException {
            this.serializedResultsFile = serializedResultsFile;
            this.diskSkipLevels = diskSkipLevels;
            this.flatteningIds = this.isDiskSkipEnabled() ? new HashSet() : Collections.emptySet();
            this.extraFlattenedDescriptors = this.isDiskSkipEnabled() ? new ArrayList() : Collections.emptyList();
            this.extraFlattenedResults = this.isDiskSkipEnabled() ? new ArrayList() : Collections.emptyList();
            Files.createDirectories(serializedResultsFile.getParent(), new FileAttribute[0]);
            this.temporaryResultsFile = Files.createTempFile(serializedResultsFile.getParent(), "in-progress-results-generic", ".bin", new FileAttribute[0]);
            this.resultsEncoder = new KryoBackedEncoder(Files.newOutputStream(this.temporaryResultsFile, new OpenOption[0]));
            this.resultsEncoder.writeSmallInt(1);
            try {
                new ZipOutputStream(Files.newOutputStream(outputZipFile, new OpenOption[0])).close();
                try {
                    this.outputZipFileSystem = FileSystems.newFileSystem(URI.create("jar:" + outputZipFile.toUri()), Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException e) {
                    throw new InvalidUserCodeException("A previous file system exists for " + outputZipFile + ", which likely means that a previous test reporter was not closed", (Throwable)e);
                }
            }
            catch (Throwable t) {
                try {
                    this.resultsEncoder.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }

        private boolean isDiskSkipEnabled() {
            return this.diskSkipLevels > 0;
        }

        @Override
        public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
            long id;
            if (this.isDiskSkipEnabled() && !Writer.isRoot(testDescriptor) && Writer.depth(testDescriptor) <= this.diskSkipLevels) {
                this.flatteningIds.add(testDescriptor.getId());
            }
            if ((id = this.nextId++) == 1L && !Writer.isRoot(testDescriptor)) {
                throw new IllegalStateException("The first test descriptor must be the root, but got: " + testDescriptor);
            }
            this.assignedIds.put(testDescriptor.getId(), id);
        }

        @Override
        public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
            if (this.isDiskSkipEnabled() && this.flatteningIds.contains(testDescriptor.getId())) {
                this.extraFlattenedDescriptors.add(testDescriptor);
                this.extraFlattenedResults.add(testResult);
                return;
            }
            SerializableTestResult.Builder testNodeBuilder = SerializableTestResult.builder().name(testDescriptor.getName()).displayName(testDescriptor.getDisplayName()).className(testDescriptor.getClassName()).classDisplayName(testDescriptor.getClassDisplayName()).startTime(testResult.getStartTime()).endTime(testResult.getEndTime()).resultType(testResult.getResultType());
            if (testResult.getAssumptionFailure() != null) {
                testNodeBuilder.assumptionFailure(Writer.convertToSerializableFailure(testResult.getAssumptionFailure()));
            }
            for (TestFailure failure : testResult.getFailures()) {
                testNodeBuilder.addFailure(Writer.convertToSerializableFailure(failure));
            }
            for (SerializedMetadata metadata : this.metadatas.removeAll((Object)testDescriptor)) {
                testNodeBuilder.addMetadata(metadata);
            }
            if (this.isDiskSkipEnabled() && Writer.isRoot(testDescriptor)) {
                boolean hasAssumptionFailure = testResult.getAssumptionFailure() != null;
                for (TestResult flattenedResult : this.extraFlattenedResults) {
                    if (flattenedResult.getAssumptionFailure() != null) {
                        if (hasAssumptionFailure) {
                            throw new IllegalStateException("Multiple assumption failures would need to be handled, but only one is supported: " + testDescriptor);
                        }
                        hasAssumptionFailure = true;
                        testNodeBuilder.assumptionFailure(Writer.convertToSerializableFailure(flattenedResult.getAssumptionFailure()));
                    }
                    for (TestFailure failure : flattenedResult.getFailures()) {
                        testNodeBuilder.addFailure(Writer.convertToSerializableFailure(failure));
                    }
                }
                this.extraFlattenedResults.clear();
                for (TestDescriptorInternal flattenedDescriptor : this.extraFlattenedDescriptors) {
                    for (SerializedMetadata metadata : this.metadatas.removeAll((Object)flattenedDescriptor)) {
                        testNodeBuilder.addMetadata(metadata);
                    }
                }
                this.extraFlattenedDescriptors.clear();
            }
            long id = this.assignedIds.remove(testDescriptor.getId());
            this.resultsEncoder.writeSmallLong(id);
            try {
                SerializableTestResult.Serializer.serialize(testNodeBuilder.build(), (Encoder)this.resultsEncoder);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            TestDescriptorInternal parent = this.getFlattenedParent(testDescriptor);
            if (parent != null) {
                Long parentId = this.assignedIds.get(parent.getId());
                if (parentId == null) {
                    throw new IllegalStateException("No id found for test descriptor: " + parent);
                }
                this.resultsEncoder.writeSmallLong(parentId.longValue());
            } else {
                this.resultsEncoder.writeSmallLong(0L);
            }
        }

        private @Nullable TestDescriptorInternal getFlattenedParent(TestDescriptorInternal testDescriptor) {
            if (!this.isDiskSkipEnabled() || Writer.isRoot(testDescriptor)) {
                return testDescriptor.getParent();
            }
            TestDescriptorInternal parent = testDescriptor.getParent();
            assert (parent != null) : "Non-root test descriptor should always have a parent: " + testDescriptor.getDisplayName() + " (id: " + testDescriptor.getId() + ")";
            while (this.flatteningIds.contains(parent.getId())) {
                if ((parent = parent.getParent()) == null) {
                    throw new AssertionError((Object)("Parent of a flattened test descriptor should not be null: " + testDescriptor.getDisplayName() + " (id: " + testDescriptor.getId() + ")"));
                }
            }
            return parent;
        }

        private static SerializableFailure convertToSerializableFailure(TestFailure failure) {
            String message = failure.getDetails().getClassName();
            if (failure.getDetails().getMessage() != null) {
                message = message + ": " + failure.getDetails().getMessage();
            }
            List<String> convertedCauses = ExceptionSerializationUtil.extractCauses((Throwable)failure.getRawFailure()).stream().map(Throwables::getStackTraceAsString).collect(Collectors.toList());
            return new SerializableFailure(message, failure.getDetails().getStacktrace(), failure.getDetails().getClassName(), convertedCauses);
        }

        @Override
        public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
            long outputId = this.isDiskSkipEnabled() && this.flatteningIds.contains(testDescriptor.getId()) ? 1L : this.assignedIds.get(testDescriptor.getId());
            Path file = this.outputZipFileSystem.getPath(Long.toString(outputId), event.getDestination().name());
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, event.getMessage().getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write output file '" + file + "'", e);
            }
        }

        @Override
        public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
            this.metadatas.put((Object)testDescriptor, (Object)new SerializedMetadata(event.getLogTime(), event.getValues()));
        }

        @Override
        public void close() throws IOException {
            try {
                this.resultsEncoder.writeSmallLong(0L);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.resultsEncoder, this.outputZipFileSystem}).stop();
                Files.move(this.temporaryResultsFile, this.serializedResultsFile, StandardCopyOption.REPLACE_EXISTING);
                throw throwable;
            }
            CompositeStoppable.stoppable((Object[])new Object[]{this.resultsEncoder, this.outputZipFileSystem}).stop();
            Files.move(this.temporaryResultsFile, this.serializedResultsFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @NullMarked
    public static final class OutputTrackedResult {
        private final long id;
        private final SerializableTestResult testResult;
        private final long parentId;

        private OutputTrackedResult(long id, SerializableTestResult testResult, long parentId) {
            this.id = id;
            this.testResult = testResult;
            this.parentId = parentId;
        }

        public SerializableTestResult getInnerResult() {
            return this.testResult;
        }

        public long getOutputId() {
            return this.id;
        }

        public OptionalLong getParentOutputId() {
            return this.parentId == 0L ? OptionalLong.empty() : OptionalLong.of(this.parentId);
        }

        public OutputTrackedResult withInnerResult(SerializableTestResult newInnerResult) {
            return new OutputTrackedResult(this.id, newInnerResult, this.parentId);
        }
    }

    @NullMarked
    public static final class OutputReader
    implements Closeable {
        private final ZipFile outputZipFile;

        private OutputReader(Path outputZipFile) throws IOException {
            this.outputZipFile = new ZipFile(outputZipFile.toFile());
        }

        private @Nullable ZipEntry getEntry(long id, TestOutputEvent.Destination destination) {
            return this.outputZipFile.getEntry(id + "/" + destination.name());
        }

        public boolean hasOutput(long id, TestOutputEvent.Destination destination) {
            return this.getEntry(id, destination) != null;
        }

        public Reader getOutput(long id, TestOutputEvent.Destination destination) {
            ZipEntry entry = this.getEntry(id, destination);
            if (entry == null) {
                return new NullReader();
            }
            try {
                return new InputStreamReader(this.outputZipFile.getInputStream(entry), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read output entry '" + entry.getName() + "'", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.outputZipFile.close();
        }
    }
}

