/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.core;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.serialize.codecs.core.AbstractVisitor;
import org.gradle.internal.serialize.codecs.core.ResolutionBackedFileCollectionSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0014\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/gradle/internal/serialize/codecs/core/ResolutionContentsCollectingVisitor;", "Lorg/gradle/internal/serialize/codecs/core/AbstractVisitor;", "resolutionHostDisplayName", "", "lenient", "", "<init>", "(Ljava/lang/String;Z)V", "containsTransforms", "getContainsTransforms", "()Z", "setContainsTransforms", "(Z)V", "elements", "", "", "getElements", "()Ljava/util/Set;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "visitCollection", "", "contents", "", "Ljava/io/File;", "addElements", "target", "core-serialization-codecs"})
final class ResolutionContentsCollectingVisitor
extends AbstractVisitor {
    @NotNull
    private final String resolutionHostDisplayName;
    private final boolean lenient;
    private boolean containsTransforms;
    @NotNull
    private final Set<Object> elements;

    public ResolutionContentsCollectingVisitor(@NotNull String resolutionHostDisplayName, boolean lenient) {
        Intrinsics.checkNotNullParameter((Object)resolutionHostDisplayName, (String)"resolutionHostDisplayName");
        this.resolutionHostDisplayName = resolutionHostDisplayName;
        this.lenient = lenient;
        this.elements = new LinkedHashSet();
    }

    public final boolean getContainsTransforms() {
        return this.containsTransforms;
    }

    public final void setContainsTransforms(boolean bl) {
        this.containsTransforms = bl;
    }

    @NotNull
    public final Set<Object> getElements() {
        return this.elements;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source instanceof TransformedArtifactSet ? FileCollectionStructureVisitor.VisitType.NoContents : FileCollectionStructureVisitor.VisitType.Visit;
    }

    public void visitCollection(@NotNull FileCollectionInternal.Source source, @NotNull Iterable<? extends File> contents) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        if (source instanceof TransformedArtifactSet) {
            this.containsTransforms = true;
            bl = this.elements.add(source);
        } else {
            bl = CollectionsKt.addAll((Collection)this.elements, contents);
        }
    }

    public final void addElements(@NotNull Set<Object> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        boolean bl = this.containsTransforms ? target.add(new ResolutionBackedFileCollectionSpec(this.resolutionHostDisplayName, this.lenient, CollectionsKt.toList((Iterable)this.elements))) : target.addAll((Collection<Object>)this.elements);
    }
}

