/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.CorePluginRegistryProvider;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.plugin.use.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.use.resolve.internal.CorePluginResolver;
import org.gradle.plugin.use.resolve.internal.NoopPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositories;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;

@ServiceScope(value={Scope.Build.class})
public class PluginResolverFactory {
    private final PluginRegistry corePluginRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver;
    private final List<PluginResolverContributor> pluginResolverContributors;

    public PluginResolverFactory(CorePluginRegistryProvider corePluginRegistryProvider, DocumentationRegistry documentationRegistry, ClientInjectedClasspathPluginResolver injectedClasspathPluginResolver, List<PluginResolverContributor> pluginResolverContributors) {
        this.corePluginRegistry = corePluginRegistryProvider.getCorePluginRegistry();
        this.documentationRegistry = documentationRegistry;
        this.injectedClasspathPluginResolver = injectedClasspathPluginResolver;
        this.pluginResolverContributors = pluginResolverContributors;
    }

    public PluginResolver create(PluginArtifactRepositories pluginResolveContext) {
        return new CompositePluginResolver(this.createDefaultResolvers(pluginResolveContext));
    }

    private List<PluginResolver> createDefaultResolvers(PluginArtifactRepositories pluginResolveContext) {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(pluginResolveContext, resolvers);
        return resolvers;
    }

    private void addDefaultResolvers(PluginArtifactRepositories pluginResolveContext, List<PluginResolver> resolvers) {
        resolvers.add(new NoopPluginResolver(this.corePluginRegistry));
        resolvers.add(new CorePluginResolver(this.documentationRegistry, this.corePluginRegistry));
        this.injectedClasspathPluginResolver.collectResolversInto(resolvers);
        this.pluginResolverContributors.forEach(contributor -> contributor.collectResolversInto(resolvers));
        resolvers.add(pluginResolveContext.getPluginResolver());
    }
}

