/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import com.google.common.io.ByteSource;
import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.util.List;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.gradle.testkit.runner.internal.DefaultBuildResult;
import org.gradle.testkit.runner.internal.feature.BuildResultOutputFeatureCheck;
import org.gradle.testkit.runner.internal.feature.FeatureCheck;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FeatureCheckBuildResult
implements BuildResult {
    private final BuildResult delegateBuildResult;
    private final FeatureCheck outputFeatureCheck;

    public FeatureCheckBuildResult(BuildOperationParameters buildOperationParameters, @NonNull String output, List<BuildTask> tasks) {
        this(buildOperationParameters, ByteSource.wrap((byte[])output.getBytes(Charset.defaultCharset())), tasks);
    }

    public FeatureCheckBuildResult(BuildOperationParameters buildOperationParameters, @NonNull ByteSource outputSource, List<BuildTask> tasks) {
        this.delegateBuildResult = new DefaultBuildResult(outputSource, tasks);
        this.outputFeatureCheck = new BuildResultOutputFeatureCheck(buildOperationParameters.getTargetGradleVersion(), buildOperationParameters.isEmbedded());
    }

    @Override
    public String getOutput() {
        this.outputFeatureCheck.verify();
        return this.delegateBuildResult.getOutput();
    }

    @Override
    public BufferedReader getOutputReader() {
        this.outputFeatureCheck.verify();
        return this.delegateBuildResult.getOutputReader();
    }

    @Override
    public List<BuildTask> getTasks() {
        return this.delegateBuildResult.getTasks();
    }

    @Override
    public List<BuildTask> tasks(TaskOutcome outcome) {
        return this.delegateBuildResult.tasks(outcome);
    }

    @Override
    public List<String> taskPaths(TaskOutcome outcome) {
        return this.delegateBuildResult.taskPaths(outcome);
    }

    @Override
    public @Nullable BuildTask task(String taskPath) {
        return this.delegateBuildResult.task(taskPath);
    }
}

