/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.gradle.testing.junit

import org.gradle.api.tasks.testing.TestResult
import org.gradle.testing.fixture.AbstractTestingMultiVersionIntegrationTest

abstract class AbstractJUnitClassLevelFilteringIntegrationTest extends AbstractTestingMultiVersionIntegrationTest {

    def setup() {
        buildFile << """
            apply plugin: 'java'
            ${mavenCentralRepository()}
            dependencies {
                ${testFrameworkDependencies}
            }
            test.${configureTestFramework}
        """
    }

    def "can filter tests from a superclass"() {
        given:
        file('src/test/java/SuperClass.java') << """
            ${testFrameworkImports}

            public abstract class SuperClass {
                @Test
                public void superTest() {
                }
            }
        """
        file('src/test/java/SubClass.java') << """
            ${testFrameworkImports}

            public class SubClass extends SuperClass {
                @Test
                public void subTest() {
                }
            }
        """

        when:
        succeeds('test', '--tests', 'SubClass.superTest')

        then:
        def result = resultsFor()
        result.assertTestPathsExecuted(':SubClass:superTest')
        result.testPath(':SubClass:superTest').onlyRoot().assertHasResult(TestResult.ResultType.SUCCESS)
    }
}
