/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.cache.Cache;
import org.gradle.cache.internal.ClassCacheFactory;
import org.gradle.cache.internal.MapBackedCache;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.DefaultInstantiatorFactory;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.state.ModelObject;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.WorkerLogEventListener;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;

public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol,
StreamFailureHandler,
Stoppable,
StreamCompletion {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient WorkerLogEventListener workerLogEventListener;
    private transient RequestHandler<Object, Object> implementation;
    private InstantiatorFactory instantiatorFactory;
    private transient Exception failure;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        ServiceRegistry parentServices = workerProcessContext.getServiceRegistry();
        this.workerLogEventListener = (WorkerLogEventListener)parentServices.get(WorkerLogEventListener.class);
        RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
        try {
            if (this.instantiatorFactory == null) {
                this.instantiatorFactory = new DefaultInstantiatorFactory((ClassCacheFactory)new BasicClassCacheFactory(), Collections.emptyList(), (PropertyRoleAnnotationHandler)new BasicPropertyRoleAnnotationHandler());
            }
            CloseableServiceRegistry serviceRegistry = ServiceRegistryBuilder.builder().displayName("worker action services").parent(parentServices).provider(registration -> {
                registration.add(RequestArgumentSerializers.class, (Object)argumentSerializers);
                registration.add(InstantiatorFactory.class, (Object)this.instantiatorFactory);
                registration.add(ResponseProtocol.class, (Object)this.responder);
            }).build();
            Class<?> workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = (RequestHandler)Cast.uncheckedNonnullCast((Object)this.instantiatorFactory.inject((ServiceLookup)serviceRegistry).newInstance(workerImplementation, new Object[0]));
        }
        catch (Exception e) {
            this.failure = e;
        }
        if (this.failure == null) {
            connection.useParameterSerializers(RequestSerializerRegistry.create(this.getClass().getClassLoader(), argumentSerializers));
        } else {
            connection.useParameterSerializers(RequestSerializerRegistry.createDiscardRequestArg());
            this.responder.infrastructureFailed(this.failure);
        }
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
        CurrentBuildOperationRef.instance().clear();
    }

    public void endStream() {
        this.stop();
    }

    @Override
    public void runThenStop(Request request) {
        try {
            this.run(request);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void run(Request request) {
        if (this.failure != null) {
            return;
        }
        CurrentBuildOperationRef.instance().with(request.getBuildOperation(), () -> {
            try {
                Object result;
                try {
                    result = this.workerLogEventListener.withWorkerLoggingProtocol((WorkerLoggingProtocol)this.responder, () -> this.implementation.run(request.getArg()));
                }
                catch (Throwable failure) {
                    if (failure instanceof NoClassDefFoundError) {
                        this.responder.infrastructureFailed(failure);
                    } else {
                        this.responder.failed(failure);
                    }
                    return;
                }
                this.responder.completed(result);
            }
            catch (Throwable t) {
                this.responder.infrastructureFailed(t);
            }
        });
    }

    public void handleStreamFailure(Throwable t) {
        this.responder.failed(t);
    }

    private static class BasicClassCacheFactory
    implements ClassCacheFactory {
        private BasicClassCacheFactory() {
        }

        public <V> Cache<Class<?>, V> newClassCache() {
            return new MapBackedCache(new ConcurrentHashMap());
        }

        public <V> Cache<Class<?>, V> newClassMap() {
            return new MapBackedCache(new ConcurrentHashMap());
        }
    }

    private static class BasicPropertyRoleAnnotationHandler
    implements PropertyRoleAnnotationHandler {
        private BasicPropertyRoleAnnotationHandler() {
        }

        public Set<Class<? extends Annotation>> getAnnotationTypes() {
            return Collections.emptySet();
        }

        public void applyRoleTo(ModelObject owner, Object target) {
            if (target instanceof PropertyInternal) {
                ((PropertyInternal)target).attachProducer(owner);
            }
        }
    }
}

