/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JavaClassUtil {
    private static final int MAGIC_BYTES = -889275714;

    private JavaClassUtil() {
    }

    public static int getClassMajorVersion(File file) throws IOException {
        return JavaClassUtil.getClassMajorVersion(new FileInputStream(file));
    }

    public static int getClassMajorVersion(Class<?> javaClass) throws IOException {
        return JavaClassUtil.getClassMajorVersion(javaClass.getName(), javaClass.getClassLoader());
    }

    public static Integer getClassMajorVersion(String name, ClassLoader loader) throws IOException {
        InputStream is = loader.getResourceAsStream(name.replace('.', '/') + ".class");
        if (is == null) {
            return null;
        }
        return JavaClassUtil.getClassMajorVersion(is);
    }

    public static int getClassMajorVersion(InputStream is) throws IOException {
        try (DataInputStream data = new DataInputStream(is);){
            if (-889275714 != data.readInt()) {
                throw new IOException("Invalid .class file header");
            }
            data.readUnsignedShort();
            int n = data.readUnsignedShort();
            return n;
        }
    }
}

