/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.DefaultBuildToolingModelController;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;

public class ResilientBuildToolingModelController
extends DefaultBuildToolingModelController {
    private static final Set<String> RESILIENT_MODELS = ImmutableSet.of((Object)"org.gradle.tooling.model.kotlin.dsl.ResilientKotlinDslScriptsModel");

    public ResilientBuildToolingModelController(BuildState buildState, BuildLifecycleController buildController, ToolingModelBuilderLookup buildScopeLookup) {
        super(buildState, buildController, buildScopeLookup);
    }

    @Override
    protected void configureProjectsForModel(String modelName) {
        try {
            super.configureProjectsForModel(modelName);
        }
        catch (GradleException e) {
            ResilientBuildToolingModelController.rethrowExceptionIfNotResilientModel(modelName, e);
        }
    }

    private static void rethrowExceptionIfNotResilientModel(String modelName, GradleException e) {
        if (!RESILIENT_MODELS.contains(modelName)) {
            throw e;
        }
    }

    @Override
    protected ToolingModelScope doLocate(ProjectState target, String modelName, boolean param) {
        return new ResilientProjectToolingScope(target, modelName, param);
    }

    private static class ResilientProjectToolingScope
    extends DefaultBuildToolingModelController.ProjectToolingScope {
        public ResilientProjectToolingScope(ProjectState target, String modelName, boolean parameter) {
            super(target, modelName, parameter);
        }

        @Override
        ToolingModelBuilderLookup.Builder locateBuilder() throws UnknownModelException {
            try {
                this.target.ensureConfigured();
            }
            catch (GradleException e) {
                ResilientBuildToolingModelController.rethrowExceptionIfNotResilientModel(this.modelName, e);
            }
            ProjectInternal project = this.target.getMutableModelEvenAfterFailure();
            ToolingModelBuilderLookup lookup = (ToolingModelBuilderLookup)project.getServices().get(ToolingModelBuilderLookup.class);
            return lookup.locateForClientOperation(this.modelName, this.parameter, this.target, project);
        }
    }
}

