/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.jspecify.annotations.Nullable;

public abstract class IntegerBuildOption<T>
extends AbstractBuildOption<T, CommandLineOptionConfiguration> {
    public IntegerBuildOption(String property) {
        super(property);
    }

    public IntegerBuildOption(String property, String deprecatedProperty) {
        super(property, deprecatedProperty);
    }

    public IntegerBuildOption(String property, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(property, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        AbstractBuildOption.OptionValue<String> propertyValue = this.getFromProperties(properties);
        String value = propertyValue.getValue();
        if (value != null) {
            this.applyTo(Integer.parseInt(value), settings, propertyValue.getOrigin());
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating()).hasArgument();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            String value = options.option(config.getLongOption()).getValue();
            this.applyTo(Integer.parseInt(value), settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    public abstract void applyTo(int var1, T var2, @Nullable Origin var3);
}

