/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Utf8;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.FileSystem;
import org.gradle.api.GradleException;

public final class SafeFileLocationUtils {
    public static final int WINDOWS_PATH_LIMIT = 260;
    private static final HashFunction HASHER = Hashing.sipHash24();
    private static final BaseEncoding BASE_ENCODING = BaseEncoding.base32Hex().omitPadding();
    private static final byte[] TRUNCATED_PREFIX_BYTES = "_cut_".getBytes(StandardCharsets.UTF_8);
    private static final int MAX_FILE_NAME_LENGTH_IN_BYTES = 255;
    @VisibleForTesting
    static final int MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES = 255 - TRUNCATED_PREFIX_BYTES.length - 1 - (HASHER.bits() + 4) / 5;
    private static final char ILLEGAL_CHAR_REPLACEMENT = '-';
    private static final ThreadLocal<CharsetEncoder> UTF_8_ENCODER_WITH_ILLEGAL_CHAR_REPLACEMENT = ThreadLocal.withInitial(() -> StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(String.valueOf('-').getBytes(StandardCharsets.UTF_8)));

    public static String toSafeFileName(String name) {
        String shortenedName = SafeFileLocationUtils.cleanAndShortenName(name);
        String result = FileSystem.WINDOWS.toLegalFileName(shortenedName, '-');
        return result.replace(' ', '-').replace('\t', '-').replace('\n', '-').replace('\r', '-');
    }

    private static String cleanAndShortenName(String name) {
        byte[] rawName;
        try {
            ByteBuffer buffer = UTF_8_ENCODER_WITH_ILLEGAL_CHAR_REPLACEMENT.get().encode(CharBuffer.wrap(name));
            rawName = new byte[buffer.remaining()];
            buffer.get(rawName);
        }
        catch (CharacterCodingException e) {
            throw new AssertionError("should never encounter an encoding error", e);
        }
        if (rawName.length <= MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES) {
            return name;
        }
        byte[] hashBytes = HASHER.hashBytes(rawName).asBytes();
        String encoded = BASE_ENCODING.encode(hashBytes);
        return SafeFileLocationUtils.shortenNameAndAddHash(rawName, encoded);
    }

    private static String shortenNameAndAddHash(byte[] rawName, String encoded) {
        int safeLength;
        ByteBuffer result = ByteBuffer.allocate(255);
        byte[] extensions = null;
        int firstDot = SafeFileLocationUtils.findStartOfExtension(rawName);
        if (firstDot > 0) {
            extensions = Arrays.copyOfRange(rawName, firstDot, rawName.length);
            safeLength = SafeFileLocationUtils.getSafeLength(rawName, MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES - extensions.length);
        } else {
            safeLength = SafeFileLocationUtils.getSafeLength(rawName, MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES);
        }
        result.put(TRUNCATED_PREFIX_BYTES);
        result.put(rawName, 0, safeLength);
        result.put((byte)45);
        byte[] encodedBytes = encoded.getBytes(StandardCharsets.US_ASCII);
        result.put(encodedBytes);
        if (extensions != null) {
            result.put(extensions);
        }
        return new String(result.array(), 0, result.position(), StandardCharsets.UTF_8);
    }

    private static int findStartOfExtension(byte[] rawName) {
        int start;
        for (int i = start = Math.max(1, rawName.length - (MAX_SAFE_FILE_NAME_LENGTH_IN_BYTES - 1)); i < rawName.length - 1; ++i) {
            if (rawName[i] != 46) continue;
            return i;
        }
        return -1;
    }

    private static int getSafeLength(byte[] rawName, int maxBytes) {
        int startOfCodePoint;
        if (rawName.length <= maxBytes) {
            return rawName.length;
        }
        for (startOfCodePoint = maxBytes - 1; startOfCodePoint > 0 && (rawName[startOfCodePoint] & 0xC0) == 128; --startOfCodePoint) {
        }
        if (Utf8.isWellFormed((byte[])rawName, (int)startOfCodePoint, (int)(maxBytes - startOfCodePoint))) {
            return maxBytes;
        }
        return startOfCodePoint;
    }

    public static File assertInWindowsPathLengthLimitation(File file) {
        if (file.getAbsolutePath().length() > 260) {
            throw new GradleException(String.format("Cannot create file. '%s' exceeds windows path limitation of %d character.", file.getAbsolutePath(), 260));
        }
        return file;
    }
}

