/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.internal.Cast;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;
import org.gradle.plugin.software.internal.DefaultLegacyProjectTypeImplementation;
import org.gradle.plugin.software.internal.DefaultProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.LegacyProjectTypeImplementation;
import org.jspecify.annotations.Nullable;

public class LegacyProjectTypeDiscovery {
    private final InspectionScheme inspectionScheme;

    public LegacyProjectTypeDiscovery(InspectionScheme inspectionScheme) {
        this.inspectionScheme = inspectionScheme;
    }

    public Set<LegacyProjectTypeImplementation<?>> discoverSoftwareTypeImplementations(Map<String, Class<? extends Plugin<Project>>> registeredTypes, Map<DefaultProjectFeatureDeclarations.RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>> pluginClasses) {
        ImmutableSet.Builder softwareTypeImplementationsBuilder = ImmutableSet.builder();
        pluginClasses.forEach((registeringPluginClass, pluginClassSet) -> pluginClassSet.forEach(pluginClass -> {
            TypeToken pluginType = TypeToken.of((Class)pluginClass);
            TypeMetadataWalker.typeWalker((TypeMetadataStore)this.inspectionScheme.getMetadataStore(), SoftwareType.class).walk((Object)pluginType, (TypeMetadataWalker.TypeMetadataVisitor)new ProjectTypeImplementationRecordingVisitor((Class<? extends Plugin<Project>>)pluginClass, registeringPluginClass.pluginClass, registeringPluginClass.pluginId, registeredTypes, (ImmutableSet.Builder<LegacyProjectTypeImplementation<?>>)softwareTypeImplementationsBuilder));
        }));
        return softwareTypeImplementationsBuilder.build();
    }

    private static class ProjectTypeImplementationRecordingVisitor
    implements TypeMetadataWalker.StaticMetadataVisitor {
        private final Class<? extends Plugin<Project>> pluginClass;
        private final @Nullable String registeringPluginId;
        private final Class<? extends Plugin<Settings>> registeringPluginClass;
        private final Map<String, Class<? extends Plugin<Project>>> registeredTypes;
        private final ImmutableSet.Builder<LegacyProjectTypeImplementation<?>> projectTypeImplementationsBuilder;

        public ProjectTypeImplementationRecordingVisitor(Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass, @Nullable String pluginId, Map<String, Class<? extends Plugin<Project>>> registeredTypes, ImmutableSet.Builder<LegacyProjectTypeImplementation<?>> projectTypeImplementationsBuilder) {
            this.pluginClass = pluginClass;
            this.registeringPluginId = pluginId;
            this.registeringPluginClass = registeringPluginClass;
            this.registeredTypes = registeredTypes;
            this.projectTypeImplementationsBuilder = projectTypeImplementationsBuilder;
        }

        public void visitRoot(TypeMetadata typeMetadata, TypeToken<?> value) {
        }

        public void visitNested(TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, TypeToken<?> value) {
            propertyMetadata.getAnnotation(SoftwareType.class).ifPresent(softwareType -> {
                Class<? extends Plugin<Project>> existingPluginClass = this.registeredTypes.put(softwareType.name(), this.pluginClass);
                if (existingPluginClass != null && existingPluginClass != this.pluginClass) {
                    throw new IllegalArgumentException("Project type '" + softwareType.name() + "' is registered by both '" + this.pluginClass.getName() + "' and '" + existingPluginClass.getName() + "'");
                }
                this.projectTypeImplementationsBuilder.add(new DefaultLegacyProjectTypeImplementation(softwareType.name(), ProjectTypeImplementationRecordingVisitor.publicTypeOf(propertyMetadata, softwareType), (Class)Cast.uncheckedNonnullCast(this.pluginClass), this.registeringPluginClass, this.registeringPluginId));
            });
        }

        private static Class<?> publicTypeOf(PropertyMetadata propertyMetadata, SoftwareType softwareType) {
            return softwareType.modelPublicType() == Void.class ? propertyMetadata.getDeclaredType().getRawType() : softwareType.modelPublicType();
        }
    }
}

