/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.gradle.api.internal.tasks.testing.DefaultGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultState;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.tasks.VerificationException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class DefaultRootTestEventReporter
extends DefaultGroupTestEventReporter {
    private final Path binaryResultsDir;
    private final SerializableTestResultStore.Writer testResultWriter;
    private final GenericHtmlTestReportGenerator htmlTestReportGenerator;
    private final TestExecutionResultsListener executionResultsListener;
    private @Nullable String failureMessage;

    DefaultRootTestEventReporter(String rootName, TestListenerInternal listener, IdGenerator<?> idGenerator, Path binaryResultsDir, SerializableTestResultStore.Writer testResultWriter, GenericHtmlTestReportGenerator htmlTestReportGenerator, TestExecutionResultsListener executionResultsListener) {
        super(listener, idGenerator, (TestDescriptorInternal)new DefaultTestSuiteDescriptor(idGenerator.generateId(), rootName), new TestResultState(null));
        this.binaryResultsDir = binaryResultsDir;
        this.testResultWriter = testResultWriter;
        this.htmlTestReportGenerator = htmlTestReportGenerator;
        this.executionResultsListener = executionResultsListener;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Throwable t) {
            try {
                this.testResultWriter.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
        try {
            this.testResultWriter.close();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        boolean rootTestFailed = this.failureMessage != null;
        this.executionResultsListener.executionResultsAvailable(this.testDescriptor, this.binaryResultsDir, rootTestFailed);
        Path reportIndexFile = this.htmlTestReportGenerator.generate(Collections.singletonList(this.binaryResultsDir));
        if (rootTestFailed) {
            String testResultsUrl = new ConsoleRenderer().asClickableFileUrl(reportIndexFile.toFile());
            throw new VerificationException(this.failureMessage + " See the test results for more details: " + testResultsUrl);
        }
    }

    @Override
    public void failed(Instant endTime, String message, String additionalContent) {
        this.failureMessage = TextUtil.isBlank((String)message) ? "Test(s) failed." : message;
        super.failed(endTime, message, additionalContent);
    }
}

