/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactSelectionDetails;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleComponentSelectorParsers;
import org.gradle.internal.Actions;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.typeconversion.NotationParser;
import org.jspecify.annotations.Nullable;

public class DefaultDependencyResolveDetails
implements DependencyResolveDetails {
    private static final NotationParser<Object, ModuleComponentSelector> USE_TARGET_NOTATION_PARSER = ModuleComponentSelectorParsers.parser("useTarget()");
    private final DependencySubstitution delegate;
    private final ModuleVersionIdentifier requested;
    private @Nullable String customDescription;
    private @Nullable VersionConstraint useVersion;
    private @Nullable ModuleComponentSelector useSelector;
    private ComponentSelector target;
    private Action<ArtifactSelectionDetails> artifactSelectionAction = Actions.doNothing();
    private boolean dirty;

    @Inject
    public DefaultDependencyResolveDetails(DependencySubstitutionInternal delegate, ModuleVersionIdentifier requested) {
        this.delegate = delegate;
        this.requested = requested;
        this.target = delegate.getConfiguredTargetSelector() != null ? delegate.getConfiguredTargetSelector() : delegate.getRequested();
    }

    public ModuleVersionSelector getRequested() {
        return DefaultModuleVersionSelector.newSelector((ModuleVersionIdentifier)this.requested);
    }

    public void useVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        this.useSelector = null;
        this.useVersion = new DefaultMutableVersionConstraint(version);
        this.dirty = true;
    }

    public void useTarget(Object notation) {
        this.useVersion = null;
        this.useSelector = (ModuleComponentSelector)USE_TARGET_NOTATION_PARSER.parseNotation(notation);
        this.dirty = true;
    }

    public DependencyResolveDetails because(String description) {
        this.customDescription = description;
        this.dirty = true;
        return this;
    }

    public DependencyResolveDetails artifactSelection(Action<? super ArtifactSelectionDetails> configurationAction) {
        this.artifactSelectionAction = Actions.composite((Action[])new Action[]{this.artifactSelectionAction, configurationAction});
        this.dirty = true;
        return this;
    }

    public ModuleVersionSelector getTarget() {
        this.complete();
        if (this.target.equals(this.delegate.getRequested())) {
            return DefaultModuleVersionSelector.newSelector((ModuleVersionIdentifier)this.requested);
        }
        if (this.target instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)((ModuleComponentSelector)this.target));
        }
        return DefaultModuleVersionSelector.newSelector((ModuleVersionIdentifier)this.requested);
    }

    public void complete() {
        if (!this.dirty) {
            return;
        }
        if (this.useSelector != null) {
            this.useTarget(this.useSelector);
        } else if (this.useVersion != null) {
            if (this.target instanceof ModuleComponentSelector) {
                ModuleComponentSelector moduleSelector = (ModuleComponentSelector)this.target;
                if (!this.useVersion.equals(moduleSelector.getVersionConstraint())) {
                    this.useTarget(DefaultModuleComponentSelector.newSelector(moduleSelector.getModuleIdentifier(), this.useVersion, moduleSelector.getAttributes(), moduleSelector.getCapabilitySelectors()));
                } else {
                    this.useTarget(this.target);
                }
            } else {
                ModuleComponentSelector newTarget = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(this.requested.getGroup(), this.requested.getName()), this.useVersion);
                this.useTarget(newTarget);
            }
        }
        this.delegate.artifactSelection(this.artifactSelectionAction);
        this.dirty = false;
    }

    private void useTarget(ModuleComponentSelector selector) {
        this.target = selector;
        if (this.customDescription != null) {
            this.delegate.useTarget((Object)selector, this.customDescription);
        } else {
            this.delegate.useTarget((Object)selector);
        }
    }
}

