/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;

public final class SelectionReasonAssessor {
    private SelectionReasonAssessor() {
    }

    public static AssessedSelection assessSelection(ModuleResolveState moduleResolveState) {
        Map<SelectorState, List<List<String>>> pathsBySelectors = moduleResolveState.getSegmentedPathsBySelectors();
        ArrayList<AssessedSelection.AssessedSelectionReason> assessedReasons = new ArrayList<AssessedSelection.AssessedSelectionReason>(pathsBySelectors.size());
        pathsBySelectors.forEach((selector, paths) -> paths.forEach(path -> assessedReasons.addAll(SelectionReasonAssessor.assessReason(selector, path))));
        return new AssessedSelection(moduleResolveState.getId(), assessedReasons);
    }

    private static List<AssessedSelection.AssessedSelectionReason> assessReason(SelectorState selectorState, List<String> pathSegments) {
        boolean isStrictRequirement = SelectionReasonAssessor.isStrictRequirement(selectorState);
        String requiredVersion = SelectionReasonAssessor.describeRequiredVersion(selectorState);
        return selectorState.getSelectionReason().getDescriptions().stream().map(selectionDescriptor -> new AssessedSelection.AssessedSelectionReason(selectorState.getRequested(), selectorState.getSelector(), pathSegments, requiredVersion, isStrictRequirement, selectionDescriptor.getCause(), SelectionReasonAssessor.describeSelectionReason(selectionDescriptor), selectorState.isFromLock())).collect(Collectors.toList());
    }

    private static boolean isStrictRequirement(SelectorState selectorState) {
        ResolvedVersionConstraint constraint = selectorState.getVersionConstraint();
        return constraint != null && constraint.isStrict();
    }

    private static String describeRequiredVersion(SelectorState selectorState) {
        ResolvedVersionConstraint versionConstraint = selectorState.getVersionConstraint();
        if (versionConstraint == null) {
            return "unspecified";
        }
        VersionSelector requiredSelector = versionConstraint.getRequiredSelector();
        return requiredSelector != null ? requiredSelector.getSelector() : "unspecified";
    }

    private static String describeSelectionReason(ComponentSelectionDescriptorInternal selectionDescriptor) {
        if (selectionDescriptor.hasCustomDescription()) {
            return selectionDescriptor.getDescription();
        }
        return StringUtils.capitalize((String)selectionDescriptor.getDescription());
    }

    public static final class AssessedSelection {
        private final ModuleIdentifier moduleId;
        private final ImmutableList<AssessedSelectionReason> reasons;

        public AssessedSelection(ModuleIdentifier moduleId, List<AssessedSelectionReason> reasons) {
            this.moduleId = moduleId;
            this.reasons = ImmutableList.copyOf(reasons);
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        public List<AssessedSelectionReason> getReasons() {
            return this.reasons;
        }

        public static final class AssessedSelectionReason {
            private final ComponentSelector requested;
            private final ComponentSelector selected;
            private final List<String> segmentedSelectionPath;
            private final String requiredVersion;
            private final boolean isStrict;
            private final ComponentSelectionCause cause;
            private final String description;
            private final boolean isFromLock;

            public AssessedSelectionReason(ComponentSelector requested, ComponentSelector selected, List<String> segmentedSelectionPath, String requiredVersion, boolean isStrict, ComponentSelectionCause cause, String description, boolean isFromLock) {
                this.requested = requested;
                this.selected = selected;
                this.segmentedSelectionPath = ImmutableList.copyOf(segmentedSelectionPath);
                this.requiredVersion = requiredVersion;
                this.isStrict = isStrict;
                this.cause = cause;
                this.description = description;
                this.isFromLock = isFromLock;
            }

            public ComponentSelector getRequested() {
                return this.requested;
            }

            public ComponentSelector getSelected() {
                return this.selected;
            }

            public List<String> getSegmentedSelectionPath() {
                return this.segmentedSelectionPath;
            }

            public String getRequiredVersion() {
                return this.requiredVersion;
            }

            public boolean isStrict() {
                return this.isStrict;
            }

            public ComponentSelectionCause getCause() {
                return this.cause;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean isFromLock() {
                return this.isFromLock;
            }
        }
    }
}

