/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.TestClassConsumer;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.CategoryFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestDryRunner;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;

public class JUnitTestClassExecutor
implements TestClassConsumer {
    private final ClassLoader applicationClassLoader;
    private final JUnitSpec spec;
    private final TestClassExecutionListener executionListener;
    private final RunListener listener;
    private @Nullable CategoryFilter categoryFilter;

    public JUnitTestClassExecutor(ClassLoader applicationClassLoader, JUnitSpec spec, Clock clock, IdGenerator<?> idGenerator, TestClassExecutionListener executionListener, TestResultProcessor threadSafeResultProcessor) {
        assert (executionListener instanceof ThreadSafe);
        this.applicationClassLoader = applicationClassLoader;
        this.spec = spec;
        this.executionListener = executionListener;
        this.listener = new JUnitTestEventAdapter(threadSafeResultProcessor, clock, idGenerator);
        if (spec.hasCategoryConfiguration()) {
            JUnitTestClassExecutor.verifyJUnitCategorySupport(applicationClassLoader);
            this.categoryFilter = new CategoryFilter(spec.getIncludeCategories(), spec.getExcludeCategories(), applicationClassLoader);
            this.categoryFilter.verifyCategories(applicationClassLoader);
        }
    }

    @Override
    public void consumeClass(String testClassName) {
        block4: {
            boolean started = false;
            try {
                Request request = this.shouldRunTestClass(testClassName);
                if (request == null) {
                    return;
                }
                this.executionListener.testClassStarted(testClassName);
                started = true;
                this.runRequest(request);
                started = false;
                this.executionListener.testClassFinished(null);
            }
            catch (Throwable throwable) {
                if (!started) {
                    throw new GradleException("Failed to execute test class: '" + testClassName + "'.", throwable);
                }
                this.executionListener.testClassFinished(TestFailure.fromTestFrameworkFailure((Throwable)throwable));
                if (!(throwable instanceof Error)) break block4;
                throw (Error)throwable;
            }
        }
    }

    private @Nullable Request shouldRunTestClass(String testClassName) throws ClassNotFoundException {
        Class<?> testClass = Class.forName(testClassName, false, this.applicationClassLoader);
        if (JUnitTestClassExecutor.isNestedClassInsideEnclosedRunner(testClass)) {
            return null;
        }
        Request filteredRequest = this.buildFilteredRequest(testClass);
        if (filteredRequest == null) {
            return null;
        }
        return filteredRequest;
    }

    private @Nullable Request buildFilteredRequest(Class<?> testClass) {
        Request originalRequest = Request.aClass(testClass);
        Runner runner = originalRequest.getRunner();
        List<Filter> filters = this.buildFilters(testClass.getName(), runner);
        if (runner instanceof Filterable) {
            Filterable filterable = (Filterable)runner;
            for (Filter filter : filters) {
                try {
                    filterable.filter(filter);
                }
                catch (NoTestsRemainException e) {
                    return null;
                }
            }
        } else if (this.allTestsFiltered(runner, filters)) {
            return null;
        }
        return new FilteredGradleRequest(runner);
    }

    private @Nullable List<Filter> buildFilters(String testClassName, Runner filteredRunner) {
        TestFilterSpec filterSpec;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.categoryFilter != null) {
            filters.add(this.categoryFilter);
        }
        if (!((filterSpec = this.spec.getFilter()).getIncludedTests().isEmpty() && filterSpec.getIncludedTestsCommandLine().isEmpty() && filterSpec.getExcludedTests().isEmpty())) {
            TestSelectionMatcher matcher = new TestSelectionMatcher(filterSpec);
            if (!filteredRunner.getDescription().isSuite() || !matcher.matchesTest(testClassName, null)) {
                filters.add(new MethodNameFilter(matcher));
            }
        }
        return filters;
    }

    private void runRequest(Request request) {
        JUnitCore junit = new JUnitCore();
        junit.addListener(this.listener);
        junit.run(request);
    }

    public static boolean isNestedClassInsideEnclosedRunner(Class<?> testClass) {
        if (testClass.getEnclosingClass() == null) {
            return false;
        }
        Class<?> outermostClass = testClass;
        while (outermostClass.getEnclosingClass() != null) {
            outermostClass = outermostClass.getEnclosingClass();
        }
        RunWith runWith = outermostClass.getAnnotation(RunWith.class);
        return runWith != null && Enclosed.class.equals((Object)runWith.value());
    }

    private static void verifyJUnitCategorySupport(ClassLoader applicationClassLoader) {
        boolean failed = false;
        try {
            applicationClassLoader.loadClass("org.junit.experimental.categories.Category");
            Class<?> desc = applicationClassLoader.loadClass("org.junit.runner.Description");
            desc.getMethod("getTestClass", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            failed = true;
        }
        if (failed) {
            throw new GradleException("JUnit Categories defined but declared JUnit version does not support Categories.");
        }
    }

    private boolean allTestsFiltered(Runner runner, List<Filter> filters) {
        LinkedList<Description> queue = new LinkedList<Description>();
        queue.add(runner.getDescription());
        while (!queue.isEmpty()) {
            Description description = (Description)queue.removeFirst();
            queue.addAll(description.getChildren());
            boolean run = true;
            for (Filter filter : filters) {
                if (filter.shouldRun(description)) continue;
                run = false;
                break;
            }
            if (!run) continue;
            return false;
        }
        return true;
    }

    @NullMarked
    private final class FilteredGradleRequest
    extends Request {
        private final Runner runner;

        private FilteredGradleRequest(Runner filteredRunner) {
            this.runner = JUnitTestClassExecutor.this.spec.isDryRun() ? new JUnitTestDryRunner(filteredRunner) : filteredRunner;
        }

        public Runner getRunner() {
            return this.runner;
        }
    }

    private static class MethodNameFilter
    extends Filter {
        private final TestSelectionMatcher matcher;

        public MethodNameFilter(TestSelectionMatcher matcher) {
            this.matcher = matcher;
        }

        public boolean shouldRun(Description description) {
            if (this.matcher.matchesTest(JUnitTestEventAdapter.className(description), JUnitTestEventAdapter.methodName(description))) {
                return true;
            }
            for (Description child : description.getChildren()) {
                if (!this.shouldRun(child)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return "Includes matching test methods";
        }
    }
}

