/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.Collections;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedDependencyGraph;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.jspecify.annotations.Nullable;

public class InMemoryResolutionResultBuilder
implements DependencyGraphVisitor {
    private final ResolutionResultGraphBuilder resolutionResultBuilder = new ResolutionResultGraphBuilder();
    private final boolean includeAllSelectableVariantResults;
    private long rootVariantId;
    private long rootComponentId;
    private @Nullable ImmutableAttributes requestAttributes;

    public InMemoryResolutionResultBuilder(boolean includeAllSelectableVariantResults) {
        this.includeAllSelectableVariantResults = includeAllSelectableVariantResults;
    }

    @Override
    public void start(RootGraphNode root) {
        this.rootVariantId = root.getNodeId();
        this.rootComponentId = root.getOwner().getResultId();
        this.requestAttributes = root.getResolveState().getAttributes();
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent component = node.getOwner();
        this.resolutionResultBuilder.startVisitComponent(component.getResultId(), component.getSelectionReason(), component.getRepositoryName(), component.getComponentId(), component.getModuleVersion());
        for (ResolvedGraphVariant variant : component.getSelectedVariants()) {
            ResolvedVariantResult publicView = component.getResolveState().getPublicViewFor(variant.getResolveState(), null);
            this.resolutionResultBuilder.visitSelectedVariant(variant.getNodeId(), publicView);
        }
        if (this.includeAllSelectableVariantResults) {
            this.resolutionResultBuilder.visitComponentVariants(component.getResolveState().getAllSelectableVariantResults());
        } else {
            this.resolutionResultBuilder.visitComponentVariants(Collections.emptyList());
        }
        this.resolutionResultBuilder.endVisitComponent();
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        this.resolutionResultBuilder.visitOutgoingEdges(node.getOwner().getResultId(), node.getNodeId(), node.getOutgoingEdges());
    }

    public MinimalResolutionResult getResolutionResult() {
        if (this.requestAttributes == null) {
            throw new IllegalStateException("Resolution result not computed yet");
        }
        ResolvedDependencyGraph graph = this.resolutionResultBuilder.getResolvedGraph(this.rootComponentId, this.rootVariantId);
        return new MinimalResolutionResult(() -> graph, this.requestAttributes);
    }
}

