/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ7\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "reportIfUnderscore", "isSingleUnderscoreAllowed", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Z)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReservedUnderscoreDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n*L\n29#1:83,2\n*E\n"})
public final class FirReservedUnderscoreDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReservedUnderscoreDeclarationChecker INSTANCE = new FirReservedUnderscoreDeclarationChecker();

    private FirReservedUnderscoreDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        if (!(declaration instanceof FirRegularClass) && (!(declaration instanceof FirProperty) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter((FirProperty)declaration), (Object)true)) && !(declaration instanceof FirTypeAlias)) break block4;
                        FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, context2, reporter, declaration, false, 8, null);
                        break block5;
                    }
                    if (!(declaration instanceof FirTypeParameter)) break block6;
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, context2, reporter, declaration, false, 8, null);
                    Iterable $this$forEach$iv = ((FirTypeParameter)declaration).getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl = false;
                        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context2, reporter, it);
                    }
                    break block5;
                }
                if (!(declaration instanceof FirFunction)) break block7;
                if (declaration instanceof FirSimpleFunction) {
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, context2, reporter, declaration, false, 8, null);
                }
                boolean isSingleUnderscoreAllowed = declaration instanceof FirAnonymousFunction || declaration instanceof FirPropertyAccessor;
                for (FirValueParameter parameter : ((FirFunction)declaration).getValueParameters()) {
                    this.reportIfUnderscore(context2, reporter, parameter, isSingleUnderscoreAllowed);
                }
                break block5;
            }
            if (!(declaration instanceof FirFile)) break block5;
            for (FirImport firImport : ((FirFile)declaration).getImports()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(context2, reporter, firImport.getAliasSource(), false);
            }
        }
    }

    private final void reportIfUnderscore(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration, boolean isSingleUnderscoreAllowed) {
        FirDeclaration firDeclaration;
        KtSourceElement declarationSource = declaration.getSource();
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind)) {
            FirProperty firProperty = declaration instanceof FirProperty ? (FirProperty)declaration : null;
            if (!Intrinsics.areEqual((Object)(firProperty != null ? firProperty.getName() : null), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
                String rawName;
                SourceNavigator $this$reportIfUnderscore_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration);
                boolean bl = false;
                String string = rawName = $this$reportIfUnderscore_u24lambda_u240.getRawName(declaration);
                boolean bl2 = string != null ? FirUnderscoreHelpersKt.isUnderscore(string) : false;
                if (!(!bl2 || isSingleUnderscoreAllowed && Intrinsics.areEqual((Object)rawName, (Object)"_"))) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), null, 8, null);
                }
            }
        }
        if ((firDeclaration = declaration) instanceof FirValueParameter) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context2, reporter, ((FirValueParameter)declaration).getReturnTypeRef());
        } else if (firDeclaration instanceof FirFunction) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context2, reporter, ((FirFunction)declaration).getReturnTypeRef());
            FirReceiverParameter firReceiverParameter = ((FirFunction)declaration).getReceiverParameter();
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context2, reporter, firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null);
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirReservedUnderscoreDeclarationChecker firReservedUnderscoreDeclarationChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirDeclaration firDeclaration, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        firReservedUnderscoreDeclarationChecker.reportIfUnderscore(checkerContext, diagnosticReporter, firDeclaration, bl);
    }
}

