/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.gradle.plugins.ide.internal.tooling.GradleBuildBuilder;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.plugins.ide.internal.tooling.model.DefaultResilientGradleBuild;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResilientGradleBuildBuilder
implements BuildScopeModelBuilder {
    private final BuildStateRegistry buildStateRegistry;
    private final BuildIncludeListener failedIncludedBuildsRegistry;

    public ResilientGradleBuildBuilder(BuildStateRegistry buildStateRegistry, BuildIncludeListener failedIncludedBuildsRegistry) {
        this.buildStateRegistry = buildStateRegistry;
        this.failedIncludedBuildsRegistry = failedIncludedBuildsRegistry;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.ResilientGradleBuild");
    }

    public DefaultResilientGradleBuild create(BuildState target) {
        return new ResilientGradleBuildCreator(target).create();
    }

    @NullMarked
    private class ResilientGradleBuildCreator {
        private final Map<BuildState, Failure> brokenBuilds = new HashMap<BuildState, Failure>();
        private final Map<SettingsInternal, Failure> brokenSettings = new HashMap<SettingsInternal, Failure>();
        private final BuildState target;
        private final Map<BuildState, DefaultGradleBuild> all = new LinkedHashMap<BuildState, DefaultGradleBuild>();

        ResilientGradleBuildCreator(BuildState target) {
            this.target = target;
        }

        DefaultResilientGradleBuild create() {
            this.ensureProjectsLoaded(this.target);
            return new DefaultResilientGradleBuild(this.convert(this.target), (Collection)Streams.concat((Stream[])new Stream[]{this.brokenBuilds.values().stream(), this.brokenSettings.values().stream()}).map(Object::toString).collect(ImmutableList.toImmutableList()));
        }

        protected void addIncludedBuilds(GradleInternal gradle, DefaultGradleBuild model) {
            for (IncludedBuildInternal reference : gradle.includedBuilds()) {
                BuildState target = reference.getTarget();
                if (target instanceof IncludedBuildState || target instanceof RootBuildState) {
                    model.addIncludedBuild(this.convert(target));
                    continue;
                }
                throw new IllegalStateException("Unknown build type: " + reference.getClass().getName());
            }
        }

        protected void addAllImportableBuilds(BuildState targetBuild, GradleInternal gradle, DefaultGradleBuild model) {
            if (gradle.getParent() == null) {
                ArrayList<DefaultGradleBuild> allBuilds = new ArrayList<DefaultGradleBuild>();
                ResilientGradleBuildBuilder.this.buildStateRegistry.visitBuilds(buildState -> {
                    if (buildState != targetBuild && buildState.isImportableBuild()) {
                        allBuilds.add(this.convert((BuildState)buildState));
                    }
                });
                model.addBuilds(allBuilds);
            }
        }

        protected void ensureProjectsLoaded(BuildState target) {
            try {
                target.ensureProjectsLoaded();
            }
            catch (GradleException e) {
                if (e.getCause() instanceof ScriptCompilationException) {
                    this.brokenBuilds.putAll(ResilientGradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenBuilds());
                    this.brokenSettings.putAll(ResilientGradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenSettings());
                    return;
                }
                throw e;
            }
        }

        protected DefaultGradleBuild convert(BuildState targetBuild) {
            DefaultGradleBuild model = this.all.get(targetBuild);
            if (model != null) {
                return model;
            }
            model = new DefaultGradleBuild();
            this.all.put(targetBuild, model);
            this.ensureProjectsLoaded(targetBuild);
            Failure failure = this.brokenBuilds.get(targetBuild);
            if (failure == null && !this.brokenSettings.isEmpty()) {
                Map.Entry<SettingsInternal, Failure> settingsEntry = this.brokenSettings.entrySet().iterator().next();
                ProjectDescriptor rootProject = settingsEntry.getKey().getRootProject();
                BasicGradleProject root = this.convertRoot(targetBuild, rootProject);
                model.setRootProject(root);
                model.addProject(root);
            }
            GradleInternal gradle = targetBuild.getMutableModel();
            if (targetBuild.isProjectsLoaded()) {
                GradleBuildBuilder.addProjects(targetBuild, model);
            }
            try {
                this.addFailedBuilds(targetBuild, model);
                this.addIncludedBuilds(gradle, model);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.addAllImportableBuilds(targetBuild, gradle, model);
            return model;
        }

        protected BasicGradleProject convertRoot(BuildState owner, ProjectDescriptor project) {
            DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getPath());
            return new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getPath()).setProjectDirectory(project.getProjectDir());
        }

        private void addFailedBuilds(BuildState targetBuild, DefaultGradleBuild model) {
            for (Map.Entry<BuildState, Failure> entry : this.brokenBuilds.entrySet()) {
                BuildState parent = entry.getKey().getParent();
                if (parent == null || !parent.equals(targetBuild)) continue;
                model.addIncludedBuild(this.convert(entry.getKey()));
            }
        }
    }
}

