/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.ConfigurationCacheInputsListener;
import org.gradle.internal.cc.impl.IgnoredConfigurationInputs;
import org.gradle.internal.cc.impl.InstrumentedInputAccessListenerKt;
import org.gradle.internal.cc.impl.UndeclaredBuildInputListener;
import org.gradle.internal.cc.impl.Workarounds;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheProblemsListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\"\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\"\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gradle/internal/cc/impl/InstrumentedInputAccessListener;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheInputsListener;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "configurationCacheProblemsListener", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;", "ignoredConfigurationInputs", "Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;", "<init>", "(Lorg/gradle/internal/event/ListenerManager;Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;)V", "undeclaredInputBroadcast", "Lorg/gradle/internal/cc/impl/UndeclaredBuildInputListener;", "externalProcessListener", "systemPropertyQueried", "", "key", "", "value", "", "consumer", "systemPropertyChanged", "systemPropertyRemoved", "systemPropertiesCleared", "envVariableQueried", "externalProcessStarted", "command", "fileOpened", "file", "Ljava/io/File;", "fileObserved", "fileSystemEntryObserved", "directoryContentObserved", "directory", "startParameterProjectPropertiesObserved", "configuration-cache"})
public final class InstrumentedInputAccessListener
implements ConfigurationCacheInputsListener {
    @NotNull
    private final IgnoredConfigurationInputs ignoredConfigurationInputs;
    @NotNull
    private final UndeclaredBuildInputListener undeclaredInputBroadcast;
    @NotNull
    private final ConfigurationCacheProblemsListener externalProcessListener;

    public InstrumentedInputAccessListener(@NotNull ListenerManager listenerManager, @NotNull ConfigurationCacheProblemsListener configurationCacheProblemsListener, @NotNull IgnoredConfigurationInputs ignoredConfigurationInputs) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        Intrinsics.checkNotNullParameter((Object)configurationCacheProblemsListener, (String)"configurationCacheProblemsListener");
        Intrinsics.checkNotNullParameter((Object)ignoredConfigurationInputs, (String)"ignoredConfigurationInputs");
        this.ignoredConfigurationInputs = ignoredConfigurationInputs;
        Object object = listenerManager.getBroadcaster(UndeclaredBuildInputListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBroadcaster(...)");
        this.undeclaredInputBroadcast = (UndeclaredBuildInputListener)object;
        this.externalProcessListener = configurationCacheProblemsListener;
    }

    public void systemPropertyQueried(@NotNull String key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (InstrumentedInputAccessListenerKt.access$getAllowedProperties$p().contains(key) || Workarounds.INSTANCE.canReadSystemProperty(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.systemPropertyRead(key, value, consumer);
    }

    public void systemPropertyChanged(@NotNull Object key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.systemPropertyChanged(key, value, consumer);
    }

    public void systemPropertyRemoved(@NotNull Object key, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.systemPropertyRemoved(key, consumer);
    }

    public void systemPropertiesCleared(@NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.systemPropertiesCleared(consumer);
    }

    public void envVariableQueried(@NotNull String key, @Nullable String value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadEnvironmentVariable(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.envVariableRead(key, value, consumer);
    }

    public void externalProcessStarted(@NotNull String command, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canStartExternalProcesses(consumer)) {
            return;
        }
        this.externalProcessListener.onExternalProcessStarted(command, consumer);
    }

    public void fileOpened(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.fileOpened(file, consumer);
    }

    public void fileObserved(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.undeclaredInputBroadcast.fileObserved(file, consumer);
    }

    public void fileSystemEntryObserved(@NotNull File file, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        if (this.ignoredConfigurationInputs.isFileSystemCheckIgnoredFor(file)) {
            return;
        }
        this.undeclaredInputBroadcast.fileSystemEntryObserved(file, consumer);
    }

    public void directoryContentObserved(@NotNull File directory, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (Workarounds.INSTANCE.canReadFiles(consumer)) {
            return;
        }
        this.undeclaredInputBroadcast.directoryChildrenObserved(directory, consumer);
    }

    public void startParameterProjectPropertiesObserved() {
        this.undeclaredInputBroadcast.startParameterProjectPropertiesObserved();
    }
}

