/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.plugin.software.internal.ProjectFeatureApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ProjectFeatureRegistry;
import org.gradle.plugin.software.internal.ProjectFeatureSupportInternal;
import org.gradle.plugin.software.internal.TargetTypeInformationChecks;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class ProjectFeaturesDynamicObject
extends AbstractDynamicObject {
    private final DynamicObjectAware target;
    private final ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context;
    public static final String CONTEXT_METHOD_NAME = "$.projectFeatureContext";

    @Inject
    public ProjectFeaturesDynamicObject(DynamicObjectAware target, ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context) {
        this.target = target;
        this.context = context;
    }

    public String getDisplayName() {
        return "project features";
    }

    public boolean hasMethod(String name, Object ... arguments) {
        return this.isFeatureConfigureMethod(name, arguments);
    }

    private boolean isFeatureConfigureMethod(String name, @Nullable Object[] arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Closure)) {
            return false;
        }
        ProjectFeatureImplementation<?, ?> feature = this.getProjectFeatureRegistry().getProjectFeatureImplementations().get(name);
        if (feature == null) {
            return false;
        }
        return TargetTypeInformationChecks.isValidBindingType(feature.getTargetDefinitionType(), this.target.getClass());
    }

    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        if (name.equals(CONTEXT_METHOD_NAME) && arguments.length == 0) {
            return DynamicInvokeResult.found((Object)this.context);
        }
        if (this.isFeatureConfigureMethod(name, arguments)) {
            Object projectFeatureConfigurationModel = this.getProjectFeatureApplicator().applyFeatureTo(this.target, this.getProjectFeatureRegistry().getProjectFeatureImplementations().get(name));
            return DynamicInvokeResult.found((Object)ConfigureUtil.configure((Closure)((Closure)arguments[0]), projectFeatureConfigurationModel));
        }
        return DynamicInvokeResult.notFound();
    }

    @Inject
    protected abstract ProjectFeatureRegistry getProjectFeatureRegistry();

    @Inject
    protected abstract ProjectFeatureApplicator getProjectFeatureApplicator();
}

