/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.file.FileTree;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalResultStoringCompiler;
import org.gradle.api.internal.tasks.compile.incremental.SelectiveCompiler;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClassSetAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilationAccess;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationAccess;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.language.base.internal.compile.Compiler;

@ServiceScope(value={Scope.Build.class})
public class IncrementalCompilerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final StringInterner interner;
    private final ClassSetAnalyzer classSetAnalyzer;

    public IncrementalCompilerFactory(BuildOperationExecutor buildOperationExecutor, StringInterner interner, ClassSetAnalyzer classSetAnalyzer) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.interner = interner;
        this.classSetAnalyzer = classSetAnalyzer;
    }

    public <T extends JavaCompileSpec> Compiler<T> makeIncremental(CleaningJavaCompiler<T> cleaningJavaCompiler, FileTree sources, RecompilationSpecProvider recompilationSpecProvider) {
        Compiler<T> rebuildAllCompiler = this.createRebuildAllCompiler(cleaningJavaCompiler, sources);
        CurrentCompilationAccess currentCompilationAccess = new CurrentCompilationAccess(this.classSetAnalyzer, this.buildOperationExecutor);
        PreviousCompilationAccess previousCompilationAccess = new PreviousCompilationAccess(this.interner);
        SelectiveCompiler<T> compiler = new SelectiveCompiler<T>(cleaningJavaCompiler, rebuildAllCompiler, recompilationSpecProvider, currentCompilationAccess, previousCompilationAccess);
        return new IncrementalResultStoringCompiler<T>(compiler, currentCompilationAccess, previousCompilationAccess);
    }

    private <T extends JavaCompileSpec> Compiler<T> createRebuildAllCompiler(CleaningJavaCompiler<T> cleaningJavaCompiler, FileTree sourceFiles) {
        return spec -> {
            spec.setSourceFiles((Iterable)sourceFiles);
            return cleaningJavaCompiler.execute((Object)spec);
        };
    }
}

