/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.plugin.software.internal.ProjectFeatureApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ProjectFeatureRegistry;
import org.gradle.plugin.software.internal.ProjectFeaturesDynamicObject;
import org.jspecify.annotations.Nullable;

public class ProjectFeatureSupportInternal {
    public static @Nullable ProjectFeatureDefinitionContext tryGetContext(Object definition) {
        DynamicInvokeResult result = ((DynamicObjectAware)definition).getAsDynamicObject().tryInvokeMethod("$.projectFeatureContext", new Object[0]);
        if (result.isFound()) {
            return (ProjectFeatureDefinitionContext)Objects.requireNonNull(result.getValue());
        }
        return null;
    }

    public static ProjectFeatureDefinitionContext getContext(DynamicObjectAware definition) {
        Optional<ProjectFeatureDefinitionContext> maybeContext = Optional.ofNullable(ProjectFeatureSupportInternal.tryGetContext(definition));
        return maybeContext.orElseThrow(() -> new IllegalStateException("Incorrect lifecycle state for definition '" + definition + "'. Expected it to have the context and build model attached already, got none. Check that the feature's apply action registers the build model for this definition."));
    }

    public static <V extends BuildModel> void attachDefinitionContext(Object target, V buildModel, ProjectFeatureApplicator projectFeatureApplicator, ProjectFeatureRegistry projectFeatureRegistry, ObjectFactory objectFactory) {
        DynamicObjectAware targetDynamicObjectAware = (DynamicObjectAware)target;
        DefaultProjectFeatureDefinitionContext context = new DefaultProjectFeatureDefinitionContext(projectFeatureApplicator, projectFeatureRegistry, objectFactory, buildModel);
        ProjectFeatureSupportInternal.addProjectFeatureDynamicObjectToDefinition(objectFactory, targetDynamicObjectAware, context);
    }

    public static void attachLegacyDefinitionContext(Object target, ProjectFeatureApplicator projectFeatureApplicator, ProjectFeatureRegistry projectFeatureRegistry, ObjectFactory objectFactory) {
        DefaultProjectFeatureDefinitionContext.Factory factory = new DefaultProjectFeatureDefinitionContext.Factory(projectFeatureApplicator, projectFeatureRegistry, objectFactory);
        DefaultProjectFeatureDefinitionContext context = factory.create(target);
        ProjectFeatureSupportInternal.addProjectFeatureDynamicObjectToDefinition(objectFactory, (DynamicObjectAware)target, context);
    }

    public static <T extends Definition<V>, V extends BuildModel> V createBuildModelInstance(ObjectFactory objectFactory, T definition, ProjectFeatureImplementation<T, V> projectFeature) {
        return (V)((BuildModel)ProjectFeatureSupportInternal.createBuildModelInstance(objectFactory, definition, projectFeature.getBuildModelImplementationType()));
    }

    public static <V> V createBuildModelInstance(ObjectFactory factory, Object definition, Class<? extends V> buildModelType) {
        if (Named.class.isAssignableFrom(buildModelType)) {
            if (Named.class.isAssignableFrom(definition.getClass())) {
                return (V)factory.newInstance(buildModelType, new Object[]{((Named)definition).getName()});
            }
            throw new IllegalArgumentException("Cannot infer a name for " + buildModelType.getSimpleName() + " because the parent object of type " + definition.getClass().getSimpleName() + " does not implement Named.");
        }
        return (V)factory.newInstance(buildModelType, new Object[0]);
    }

    private static void addProjectFeatureDynamicObjectToDefinition(ObjectFactory objectFactory, DynamicObjectAware dslObjectToInitialize, ProjectFeatureDefinitionContext context) {
        ((ExtensibleDynamicObject)dslObjectToInitialize.getAsDynamicObject()).addObject((DynamicObject)objectFactory.newInstance(ProjectFeaturesDynamicObject.class, new Object[]{dslObjectToInitialize, context}), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    public static interface ProjectFeatureDefinitionContext {
        public Object getBuildModel();

        public Map<ProjectFeatureImplementation<?, ?>, Object> childrenDefinitions();

        public ChildDefinitionAdditionResult getOrAddChildDefinition(ProjectFeatureImplementation<?, ?> var1, Supplier<Object> var2);

        public ProjectFeatureApplicator getProjectFeatureApplicator();

        public ProjectFeatureRegistry getProjectFeatureRegistry();

        public ObjectFactory objectFactory();

        public static final class ChildDefinitionAdditionResult {
            public final boolean isNew;
            public final Object definition;

            public ChildDefinitionAdditionResult(boolean isNew, Object definition) {
                this.isNew = isNew;
                this.definition = definition;
            }
        }
    }

    public static class DefaultProjectFeatureDefinitionContext
    implements ProjectFeatureDefinitionContext {
        private final ProjectFeatureApplicator projectFeatureApplicator;
        private final ProjectFeatureRegistry projectFeatureRegistry;
        private final ObjectFactory objectFactory;
        protected final Object buildModel;
        private final Map<ProjectFeatureImplementation<?, ?>, Object> childrenDefinitions = new LinkedHashMap();

        public DefaultProjectFeatureDefinitionContext(ProjectFeatureApplicator projectFeatureApplicator, ProjectFeatureRegistry projectFeatureRegistry, ObjectFactory objectFactory, Object buildModel) {
            this.projectFeatureApplicator = projectFeatureApplicator;
            this.projectFeatureRegistry = projectFeatureRegistry;
            this.objectFactory = objectFactory;
            this.buildModel = buildModel;
        }

        @Override
        public Object getBuildModel() {
            return this.buildModel;
        }

        @Override
        public Map<ProjectFeatureImplementation<?, ?>, Object> childrenDefinitions() {
            return Collections.unmodifiableMap(this.childrenDefinitions);
        }

        @Override
        public ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult getOrAddChildDefinition(ProjectFeatureImplementation<?, ?> feature, Supplier<Object> computeDefinition) {
            if (this.childrenDefinitions.containsKey(feature)) {
                return new ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult(false, this.childrenDefinitions.get(feature));
            }
            Object definition = computeDefinition.get();
            this.childrenDefinitions.put(feature, definition);
            return new ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult(true, definition);
        }

        @Override
        public ProjectFeatureApplicator getProjectFeatureApplicator() {
            return this.projectFeatureApplicator;
        }

        @Override
        public ProjectFeatureRegistry getProjectFeatureRegistry() {
            return this.projectFeatureRegistry;
        }

        @Override
        public ObjectFactory objectFactory() {
            return this.objectFactory;
        }

        public static class Factory {
            private final ProjectFeatureApplicator projectFeatureApplicator;
            private final ProjectFeatureRegistry projectFeatureRegistry;
            private final ObjectFactory objectFactory;

            @Inject
            public Factory(ProjectFeatureApplicator projectFeatureApplicator, ProjectFeatureRegistry projectFeatureRegistry, ObjectFactory objectFactory) {
                this.projectFeatureApplicator = projectFeatureApplicator;
                this.projectFeatureRegistry = projectFeatureRegistry;
                this.objectFactory = objectFactory;
            }

            public DefaultProjectFeatureDefinitionContext create(Object buildModel) {
                return new DefaultProjectFeatureDefinitionContext(this.projectFeatureApplicator, this.projectFeatureRegistry, this.objectFactory, buildModel);
            }
        }
    }
}

