/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioFiltersFile;
import org.gradle.internal.serialization.Cached;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateFiltersFileTask
extends XmlGeneratorTask<VisualStudioFiltersFile> {
    private transient DefaultVisualStudioProject visualStudioProject;
    private final Provider<File> outputFile = this.getProject().provider(SerializableLambdas.callable((SerializableLambdas.SerializableCallable & Serializable)() -> this.visualStudioProject.getFiltersFile().getLocation()));
    private final Cached<FiltersSpec> spec = Cached.of(this::calculateSpec);

    @Inject
    public GenerateFiltersFileTask(DefaultVisualStudioProject visualStudioProject) {
        this.setVisualStudioProject(visualStudioProject);
    }

    protected boolean getIncremental() {
        return true;
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Internal
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    @Nested
    @Incubating
    protected FiltersSpec getFilterSpec() {
        return (FiltersSpec)this.spec.get();
    }

    public File getInputFile() {
        return null;
    }

    public File getOutputFile() {
        return (File)this.outputFile.get();
    }

    protected void configure(VisualStudioFiltersFile filtersFile) {
        FiltersSpec spec = (FiltersSpec)this.spec.get();
        for (File sourceFile : spec.sourceFiles) {
            filtersFile.addSource(sourceFile);
        }
        for (File headerFile : spec.headerFiles) {
            filtersFile.addHeader(headerFile);
        }
        for (Action xmlAction : spec.actions) {
            this.getXmlTransformer().addAction(xmlAction);
        }
    }

    protected VisualStudioFiltersFile create() {
        return new VisualStudioFiltersFile(this.getXmlTransformer(), (Transformer<String, File>)((FiltersSpec)this.spec.get()).fileNameTransformer);
    }

    private FiltersSpec calculateSpec() {
        return new FiltersSpec((FileCollection)this.visualStudioProject.getSourceFiles(), (FileCollection)this.visualStudioProject.getHeaderFiles(), this.visualStudioProject.getFiltersFile().getXmlActions(), RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getFiltersFile().getLocation()));
    }

    @Incubating
    protected static class FiltersSpec {
        private final FileCollection sourceFiles;
        private final FileCollection headerFiles;
        private final List<Action<? super XmlProvider>> actions;
        private final Transformer<String, File> fileNameTransformer;

        private FiltersSpec(FileCollection sourceFiles, FileCollection headerFiles, List<Action<? super XmlProvider>> actions, Transformer<String, File> fileNameTransformer) {
            this.sourceFiles = sourceFiles;
            this.headerFiles = headerFiles;
            this.actions = actions;
            this.fileNameTransformer = fileNameTransformer;
        }

        @Input
        @Incubating
        public Provider<Set<String>> getSourceFilePaths() {
            return this.sourceFiles.getElements().map(files -> CollectionUtils.collect((Set)files, file -> file.getAsFile().getAbsolutePath()));
        }

        @Input
        @Incubating
        public Provider<Set<String>> getHeaderFilesPaths() {
            return this.headerFiles.getElements().map(files -> CollectionUtils.collect((Set)files, file -> file.getAsFile().getAbsolutePath()));
        }

        @Nested
        @Incubating
        public List<Action<? super XmlProvider>> getActions() {
            return this.actions;
        }
    }
}

