/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.util.Path;

public class DefaultProjectComponentIdentifier
implements ProjectComponentIdentifierInternal {
    private final ProjectIdentity projectIdentity;

    public DefaultProjectComponentIdentifier(ProjectIdentity projectIdentity) {
        this.projectIdentity = projectIdentity;
    }

    @Override
    public ProjectIdentity getProjectIdentity() {
        return this.projectIdentity;
    }

    public String getDisplayName() {
        return this.projectIdentity.getDisplayName();
    }

    public BuildIdentifier getBuild() {
        return new DefaultBuildIdentifier(this.projectIdentity.getBuildPath());
    }

    @Override
    public Path getIdentityPath() {
        return this.projectIdentity.getBuildTreePath();
    }

    public String getProjectPath() {
        return this.projectIdentity.getProjectPath().asString();
    }

    public String getBuildTreePath() {
        return this.projectIdentity.getBuildTreePath().asString();
    }

    public String getProjectName() {
        return this.projectIdentity.getProjectName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectComponentIdentifier that = (DefaultProjectComponentIdentifier)o;
        return this.projectIdentity.equals((Object)that.projectIdentity);
    }

    public int hashCode() {
        return this.projectIdentity.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

