/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.internal.locklistener.DefaultFileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockContentionHandler.class);
    private static final int PING_DELAY = 1000;
    private static final int UNKNOWN_PORT = Integer.MIN_VALUE;
    private final Lock lock = new ReentrantLock();
    private final Long2ObjectOpenHashMap<ContendedAction> contendedActions = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<FileLockReleasedSignal> lockReleasedSignals = new Long2ObjectOpenHashMap();
    private final Long2IntOpenHashMap unlocksRequestedFrom = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap unlocksConfirmedFrom = new Long2IntOpenHashMap();
    private final FileLockCommunicator communicator;
    private final InetAddressProvider inetAddressProvider;
    private final ExecutorFactory executorFactory;
    private ManagedExecutor fileLockRequestListener;
    private ManagedExecutor unlockActionExecutor;
    private boolean stopped;
    private volatile boolean listenerFailed;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressProvider inetAddressProvider) {
        this(new DefaultFileLockCommunicator(inetAddressProvider), inetAddressProvider, executorFactory);
    }

    DefaultFileLockContentionHandler(FileLockCommunicator communicator, InetAddressProvider inetAddressProvider, ExecutorFactory executorFactory) {
        this.communicator = communicator;
        this.inetAddressProvider = inetAddressProvider;
        this.executorFactory = executorFactory;
    }

    private Runnable listener() {
        return new Runnable(){
            private int failureCount = 0;

            @Override
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private void doRun() {
                while (true) {
                    try {
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).lock();
                            try {
                                if (DefaultFileLockContentionHandler.access$200(DefaultFileLockContentionHandler.this)) {
                                    return;
                                }
                            }
                            finally {
                                DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).unlock();
                            }
                            received = DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).receive();
                            if (!received.isPresent()) continue;
                            packet = received.get();
                            payload = DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).decode(packet);
                            DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).lock();
                            try {
                                contendedAction = (ContendedAction)DefaultFileLockContentionHandler.access$400(DefaultFileLockContentionHandler.this).get(payload.getLockId());
                                if (contendedAction == null) {
                                    DefaultFileLockContentionHandler.access$500(DefaultFileLockContentionHandler.this, payload, packet.getPort());
                                } else {
                                    ContendedAction.access$600(contendedAction, packet.getSocketAddress());
                                    if (!ContendedAction.access$700(contendedAction)) {
                                        DefaultFileLockContentionHandler.access$800(DefaultFileLockContentionHandler.this, contendedAction);
                                    }
                                    DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).confirmUnlockRequest(packet.getSocketAddress(), payload.getLockId());
                                }
                                this.failureCount = 0;
                            }
                            finally {
                                DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).unlock();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        ++this.failureCount;
                        if (this.failureCount < 100) continue;
                        DefaultFileLockContentionHandler.access$000().error("Problems handling incoming lock requests.", t);
                        DefaultFileLockContentionHandler.access$902(DefaultFileLockContentionHandler.this, true);
                        return;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
        };
    }

    private void startLockReleaseAsLockHolder(ContendedAction contendedAction) {
        contendedAction.running = true;
        this.unlockActionExecutor.execute((Runnable)contendedAction);
    }

    private void acceptConfirmationAsLockRequester(FileLockPacketPayload payload, int port) {
        long lockId = payload.getLockId();
        if (payload.getType() == FileLockPacketType.LOCK_RELEASE_CONFIRMATION) {
            LOGGER.debug("Process at port {} confirmed lock release for lock with id {}.", (Object)port, (Object)lockId);
            FileLockReleasedSignal signal = (FileLockReleasedSignal)this.lockReleasedSignals.get(lockId);
            if (signal != null) {
                LOGGER.debug("Triggering lock release signal for lock with id {}.", (Object)lockId);
                signal.trigger();
            }
        } else {
            LOGGER.debug("Process at port {} confirmed unlock request for lock with id {}.", (Object)port, (Object)lockId);
            this.unlocksConfirmedFrom.put(lockId, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(long lockId, Consumer<FileLockReleasedSignal> whenContended) {
        this.lock.lock();
        try {
            if (this.unlockActionExecutor == null) {
                this.unlockActionExecutor = this.executorFactory.create("File lock release action executor");
            }
            if (this.fileLockRequestListener == null) {
                this.fileLockRequestListener = this.executorFactory.create("File lock request listener");
                this.fileLockRequestListener.execute(this.listener());
            }
            this.lockReleasedSignals.remove(lockId);
            this.unlocksRequestedFrom.remove(lockId);
            this.unlocksConfirmedFrom.remove(lockId);
            this.assertNotStopped();
            if (this.contendedActions.containsKey(lockId)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(lockId, (Object)new ContendedAction(lockId, whenContended));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybePingOwner(int port, long lockId, String displayName, long timeElapsed, FileLockReleasedSignal signal) {
        assert (port != Integer.MIN_VALUE);
        if (port == this.unlocksConfirmedFrom.getOrDefault(lockId, Integer.MIN_VALUE)) {
            return false;
        }
        if (timeElapsed < 1000L && port == this.unlocksRequestedFrom.getOrDefault(lockId, Integer.MIN_VALUE)) {
            return false;
        }
        boolean pingSentSuccessfully = this.getCommunicator().pingOwner(this.inetAddressProvider.getCommunicationAddress(), port, lockId, displayName);
        if (pingSentSuccessfully) {
            this.lock.lock();
            try {
                this.unlocksRequestedFrom.put(lockId, port);
                this.lockReleasedSignals.put(lockId, (Object)signal);
            }
            finally {
                this.lock.unlock();
            }
        }
        return pingSentSuccessfully;
    }

    @Override
    public boolean isRunning() {
        return !this.listenerFailed;
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    @Override
    public void stop(long lockId) {
        this.lock.lock();
        try {
            this.contendedActions.remove(lockId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            this.communicator.stop();
        }
        finally {
            this.lock.unlock();
        }
        if (this.unlockActionExecutor != null) {
            this.unlockActionExecutor.stop();
        }
        if (this.fileLockRequestListener != null) {
            this.fileLockRequestListener.stop();
        }
    }

    @Override
    public int reservePort() {
        this.lock.lock();
        try {
            this.assertNotStopped();
        }
        finally {
            this.lock.unlock();
        }
        return this.getCommunicator().getPort();
    }

    private FileLockCommunicator getCommunicator() {
        return this.communicator;
    }

    static /* synthetic */ Lock access$100(DefaultFileLockContentionHandler x0) {
        return x0.lock;
    }

    static /* synthetic */ boolean access$200(DefaultFileLockContentionHandler x0) {
        return x0.stopped;
    }

    static /* synthetic */ Long2ObjectOpenHashMap access$400(DefaultFileLockContentionHandler x0) {
        return x0.contendedActions;
    }

    static /* synthetic */ void access$500(DefaultFileLockContentionHandler x0, FileLockPacketPayload x1, int x2) {
        x0.acceptConfirmationAsLockRequester(x1, x2);
    }

    static /* synthetic */ void access$800(DefaultFileLockContentionHandler x0, ContendedAction x1) {
        x0.startLockReleaseAsLockHolder(x1);
    }

    static /* synthetic */ boolean access$902(DefaultFileLockContentionHandler x0, boolean x1) {
        x0.listenerFailed = x1;
        return x0.listenerFailed;
    }

    private class ContendedAction
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final long lockId;
        private final Consumer<FileLockReleasedSignal> action;
        private Set<SocketAddress> requesters = new LinkedHashSet<SocketAddress>();
        private boolean running;

        private ContendedAction(long lockId, Consumer<FileLockReleasedSignal> action) {
            this.lockId = lockId;
            this.action = action;
        }

        @Override
        public void run() {
            this.action.accept(() -> {
                Set<SocketAddress> requesters = this.consumeRequesters();
                if (requesters == null) {
                    throw new IllegalStateException("trigger() has already been called and must at most be called once");
                }
                DefaultFileLockContentionHandler.this.communicator.confirmLockRelease(requesters, this.lockId);
            });
        }

        private void addRequester(SocketAddress contender) {
            this.lock.lock();
            try {
                if (this.requesters != null) {
                    this.requesters.add(contender);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private Set<SocketAddress> consumeRequesters() {
            this.lock.lock();
            try {
                Set<SocketAddress> set = this.requesters;
                return set;
            }
            finally {
                this.requesters = null;
                this.lock.unlock();
            }
        }

        static /* synthetic */ void access$600(ContendedAction x0, SocketAddress x1) {
            x0.addRequester(x1);
        }

        static /* synthetic */ boolean access$700(ContendedAction x0) {
            return x0.running;
        }
    }
}

