/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableSet;
import java.util.IdentityHashMap;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class AttributeDesugaring {
    private final IdentityHashMap<ImmutableAttributes, ImmutableAttributes> desugared = new IdentityHashMap();
    private final AttributesFactory attributesFactory;

    public AttributeDesugaring(AttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public ImmutableAttributes desugar(ImmutableAttributes attributes) {
        if (attributes.isEmpty()) {
            return attributes;
        }
        return this.desugared.computeIfAbsent(attributes, key -> {
            AttributeContainerInternal mutable = this.attributesFactory.mutable();
            ImmutableSet keySet = key.keySet();
            for (Attribute attribute : keySet) {
                Object value = key.getAttribute(attribute);
                Attribute desugared = (Attribute)Cast.uncheckedCast((Object)attribute);
                if (attribute.getType() == Boolean.class || attribute.getType() == String.class) {
                    mutable.attribute(desugared, value);
                    continue;
                }
                desugared = (Attribute)Cast.uncheckedCast((Object)Attribute.of((String)attribute.getName(), String.class));
                mutable.attribute(desugared, (Object)value.toString());
            }
            return mutable.asImmutable();
        });
    }

    public ComponentSelector desugarSelector(ComponentSelector selector) {
        DefaultProjectComponentSelector projectSelector;
        ImmutableAttributes projectAttributes;
        ModuleComponentSelector module;
        AttributeContainer moduleAttributes;
        if (selector instanceof ModuleComponentSelector && !(moduleAttributes = (module = (ModuleComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)moduleAttributes).asImmutable();
            return DefaultModuleComponentSelector.newSelector(module.getModuleIdentifier(), module.getVersionConstraint(), (AttributeContainer)this.desugar(attributes), module.getCapabilitySelectors());
        }
        if (selector instanceof DefaultProjectComponentSelector && !(projectAttributes = (projectSelector = (DefaultProjectComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)projectAttributes).asImmutable();
            return DefaultProjectComponentSelector.withAttributes(projectSelector, this.desugar(attributes));
        }
        return selector;
    }
}

