/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.management;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.initialization.resolve.RulesMode;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.initialization.StandaloneDomainObjectContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.management.DefaultVersionCatalogBuilderContainer;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultDependencyResolutionManagement
implements DependencyResolutionManagementInternal {
    private static final DisplayName UNKNOWN_CODE = Describables.of((Object)"unknown code");
    private static final Logger LOGGER = Logging.getLogger(DependencyResolutionManagement.class);
    private final List<Action<? super ComponentMetadataHandler>> componentMetadataRulesActions = new ArrayList<Action<? super ComponentMetadataHandler>>();
    private final Lazy<DependencyResolutionServices> dependencyResolutionServices;
    private final UserCodeApplicationContext context;
    private final ComponentMetadataHandler registar = new ComponentMetadataRulesRegistar();
    private final Property<RepositoriesMode> repositoryMode;
    private final Property<RulesMode> rulesMode;
    private final Property<String> librariesExtensionName;
    private final Property<String> projectsExtensionName;
    private final DefaultVersionCatalogBuilderContainer versionCatalogs;
    private boolean mutable = true;

    @Inject
    public DefaultDependencyResolutionManagement(UserCodeApplicationContext context, DependencyManagementServices dependencyManagementServices, ObjectFactory objects, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.context = context;
        this.repositoryMode = objects.property(RepositoriesMode.class).convention((Object)RepositoriesMode.PREFER_PROJECT);
        this.rulesMode = objects.property(RulesMode.class).convention((Object)RulesMode.PREFER_PROJECT);
        this.dependencyResolutionServices = Lazy.locking().of(() -> dependencyManagementServices.newDetachedResolver((DomainObjectContext)StandaloneDomainObjectContext.ANONYMOUS));
        this.librariesExtensionName = objects.property(String.class).convention((Object)"libs");
        this.projectsExtensionName = objects.property(String.class).convention((Object)"projects");
        this.versionCatalogs = (DefaultVersionCatalogBuilderContainer)((Object)objects.newInstance(DefaultVersionCatalogBuilderContainer.class, new Object[]{collectionCallbackActionDecorator, objects, context, this.dependencyResolutionServices}));
    }

    public void repositories(Action<? super RepositoryHandler> repositoryConfiguration) {
        repositoryConfiguration.execute((Object)((DependencyResolutionServices)this.dependencyResolutionServices.get()).getResolveRepositoryHandler());
    }

    public void components(Action<? super ComponentMetadataHandler> registration) {
        this.assertMutable();
        this.componentMetadataRulesActions.add(registration);
    }

    public ComponentMetadataHandler getComponents() {
        return this.registar;
    }

    public RepositoryHandler getRepositories() {
        return ((DependencyResolutionServices)this.dependencyResolutionServices.get()).getResolveRepositoryHandler();
    }

    public Property<RepositoriesMode> getRepositoriesMode() {
        return this.repositoryMode;
    }

    public Property<RulesMode> getRulesMode() {
        return this.rulesMode;
    }

    public DependencyResolutionManagementInternal.RepositoriesModeInternal getConfiguredRepositoriesMode() {
        this.repositoryMode.finalizeValue();
        return DependencyResolutionManagementInternal.RepositoriesModeInternal.of((RepositoriesMode)((RepositoriesMode)this.repositoryMode.get()));
    }

    public void versionCatalogs(Action<? super MutableVersionCatalogContainer> spec) {
        spec.execute((Object)this.versionCatalogs);
    }

    public MutableVersionCatalogContainer getVersionCatalogs() {
        return this.versionCatalogs;
    }

    public DependencyResolutionManagementInternal.RulesModeInternal getConfiguredRulesMode() {
        this.rulesMode.finalizeValue();
        return DependencyResolutionManagementInternal.RulesModeInternal.of((RulesMode)((RulesMode)this.rulesMode.get()));
    }

    public Property<String> getDefaultProjectsExtensionName() {
        return this.projectsExtensionName;
    }

    public Property<String> getDefaultLibrariesExtensionName() {
        return this.librariesExtensionName;
    }

    public List<VersionCatalogBuilder> getDependenciesModelBuilders() {
        return ImmutableList.copyOf((Collection)((Object)this.versionCatalogs));
    }

    public void configureProject(ProjectInternal project) {
        if (!this.getConfiguredRepositoriesMode().useProjectRepositories()) {
            project.getRepositories().whenObjectAdded(this::repoMutationDisallowedOnProject);
        }
        if (!this.getConfiguredRulesMode().useProjectRules()) {
            ComponentMetadataHandlerInternal components = (ComponentMetadataHandlerInternal)project.getDependencies().getComponents();
            components.onAddRule(this::ruleMutationDisallowedOnProject);
        }
    }

    public void preventFromFurtherMutation() {
        this.mutable = false;
        RepositoryHandler repositoryHandler = this.getRepositories();
        repositoryHandler.whenObjectAdded(this::mutationDisallowed);
        repositoryHandler.whenObjectRemoved(this::mutationDisallowed);
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new InvalidUserCodeException("Mutation of dependency resolution management in settings is only allowed during settings evaluation");
        }
    }

    private void mutationDisallowed(ArtifactRepository artifactRepository) {
        throw new InvalidUserCodeException("Mutation of repositories declared in settings is only allowed during settings evaluation");
    }

    private void repoMutationDisallowedOnProject(ArtifactRepository artifactRepository) {
        DisplayName displayName;
        UserCodeApplicationContext.Application current = this.context.current();
        DisplayName displayName2 = displayName = current == null ? null : current.getSource().getDisplayName();
        if (displayName == null) {
            displayName = UNKNOWN_CODE;
        }
        String message = "Build was configured to prefer settings repositories over project repositories but repository '" + artifactRepository.getName() + "' was added by " + displayName;
        switch (this.getConfiguredRepositoriesMode()) {
            case FAIL_ON_PROJECT_REPOS: {
                throw new InvalidUserCodeException(message);
            }
            case PREFER_SETTINGS: {
                LOGGER.warn(message);
                break;
            }
        }
    }

    private void ruleMutationDisallowedOnProject(DisplayName ruleName) {
        DisplayName displayName;
        UserCodeApplicationContext.Application current = this.context.current();
        DisplayName displayName2 = displayName = current == null ? null : current.getSource().getDisplayName();
        if (displayName == null) {
            displayName = UNKNOWN_CODE;
        }
        String message = "Build was configured to prefer settings component metadata rules over project rules but rule '" + ruleName + "' was added by " + displayName;
        switch (this.getConfiguredRulesMode()) {
            case FAIL_ON_PROJECT_RULES: {
                throw new InvalidUserCodeException(message);
            }
            case PREFER_SETTINGS: {
                LOGGER.warn(message);
                break;
            }
        }
    }

    public void applyRules(ComponentMetadataHandler target) {
        for (Action<? super ComponentMetadataHandler> rule : this.componentMetadataRulesActions) {
            rule.execute((Object)target);
        }
    }

    private class ComponentMetadataRulesRegistar
    implements ComponentMetadataHandler {
        private ComponentMetadataRulesRegistar() {
        }

        public ComponentMetadataHandler all(Action<? super ComponentMetadataDetails> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.all(rule)));
            return this;
        }

        public ComponentMetadataHandler all(Closure<?> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.all(rule)));
            return this;
        }

        @Deprecated
        public ComponentMetadataHandler all(Object ruleSource) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.all(ruleSource)));
            return this;
        }

        public ComponentMetadataHandler all(Class<? extends ComponentMetadataRule> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.all(rule)));
            return this;
        }

        public ComponentMetadataHandler all(Class<? extends ComponentMetadataRule> rule, Action<? super ActionConfiguration> configureAction) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.all(rule, configureAction)));
            return this;
        }

        public ComponentMetadataHandler withModule(Object id, Action<? super ComponentMetadataDetails> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.withModule(id, rule)));
            return this;
        }

        public ComponentMetadataHandler withModule(Object id, Closure<?> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.withModule(id, rule)));
            return this;
        }

        @Deprecated
        public ComponentMetadataHandler withModule(Object id, Object ruleSource) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.withModule(id, ruleSource)));
            return this;
        }

        public ComponentMetadataHandler withModule(Object id, Class<? extends ComponentMetadataRule> rule) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.withModule(id, rule)));
            return this;
        }

        public ComponentMetadataHandler withModule(Object id, Class<? extends ComponentMetadataRule> rule, Action<? super ActionConfiguration> configureAction) {
            DefaultDependencyResolutionManagement.this.components((Action<? super ComponentMetadataHandler>)((Action)h -> h.withModule(id, rule, configureAction)));
            return this;
        }
    }
}

