/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.net.URI;
import java.util.Set;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.resource.DownloadedUriTextResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.resource.UriTextResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class CachingTextUriResourceLoader
implements TextUriResourceLoader {
    private final ExternalResourceAccessor externalResourceAccessor;
    private final Set<String> cachedSchemes;
    private final RelativeFilePathResolver resolver;

    public CachingTextUriResourceLoader(ExternalResourceAccessor externalResourceAccessor, Set<String> cachedSchemes, RelativeFilePathResolver resolver) {
        this.externalResourceAccessor = externalResourceAccessor;
        this.cachedSchemes = cachedSchemes;
        this.resolver = resolver;
    }

    public TextResource loadUri(String description, URI source) {
        if (this.isCacheable(source)) {
            LocallyAvailableExternalResource resource = this.externalResourceAccessor.resolveUri(source);
            if (resource == null) {
                throw ResourceExceptions.getMissing((URI)source);
            }
            ExternalResourceMetaData metaData = resource.getMetaData();
            String contentType = metaData == null ? null : metaData.getContentType();
            return new DownloadedUriTextResource(description, source, contentType, resource.getFile(), this.resolver);
        }
        return new UriTextResource(description, source, this.resolver);
    }

    private boolean isCacheable(URI source) {
        return this.isCacheableScheme(source) && this.isCacheableResource(source);
    }

    private boolean isCacheableScheme(URI source) {
        return this.cachedSchemes.contains(source.getScheme());
    }

    private boolean isCacheableResource(URI source) {
        return source.getRawQuery() == null;
    }
}

