/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.JavaVersion;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeActionExecutor;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.VersionNumber;

public class RootBuildLifecycleBuildActionExecutor
implements BuildTreeActionExecutor {
    private final BuildActionRunner buildActionRunner;
    private final BuildStateRegistry buildStateRegistry;

    public RootBuildLifecycleBuildActionExecutor(BuildStateRegistry buildStateRegistry, BuildActionRunner buildActionRunner) {
        this.buildActionRunner = buildActionRunner;
        this.buildStateRegistry = buildStateRegistry;
    }

    public BuildActionRunner.Result execute(BuildAction action, BuildTreeContext buildTreeContext) {
        int currentMajor = Integer.parseInt(JavaVersion.current().getMajorVersion());
        if (currentMajor < 17) {
            int currentMajorGradleVersion = VersionNumber.parse((String)GradleVersion.current().getVersion()).getMajor();
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Executing Gradle on JVM versions %d and lower", 16)).withContext(String.format("Use JVM %d or greater to execute Gradle. Projects can continue to use older JVM versions via toolchains.", 17))).willBecomeAnErrorInNextMajorGradleVersion().withUpgradeGuideSection(currentMajorGradleVersion, "minimum_daemon_jvm_version")).nagUser();
        }
        RootBuildState rootBuild = this.buildStateRegistry.createRootBuild(BuildDefinition.fromStartParameter((StartParameterInternal)action.getStartParameter(), null));
        return (BuildActionRunner.Result)rootBuild.run(buildController -> this.buildActionRunner.run(action, buildController));
    }
}

