/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class CompositePluginResolver
implements PluginResolver {
    private final List<PluginResolver> repositories;

    public CompositePluginResolver(List<PluginResolver> repositories) {
        this.repositories = repositories;
    }

    @Override
    public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
        ImmutableList.Builder notFoundList = ImmutableList.builder();
        for (PluginResolver repository : this.repositories) {
            PluginResolutionResult result = repository.resolve(pluginRequest);
            if (result.isFound()) {
                return result;
            }
            notFoundList.addAll(result.getNotFound());
        }
        return PluginResolutionResult.notFound((ImmutableList<PluginResolutionResult.NotFound>)notFoundList.build());
    }
}

