/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelSpec;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;
import org.jspecify.annotations.Nullable;

public abstract class NodePredicate {
    private final Predicate<? super MutableModelNode> matcher;

    private NodePredicate(Predicate<? super MutableModelNode> matcher) {
        this.matcher = matcher;
    }

    public ModelSpec scope(ModelPath scope) {
        return this.scope(scope, this.matcher);
    }

    protected abstract ModelSpec scope(ModelPath var1, Predicate<? super MutableModelNode> var2);

    public static NodePredicate allLinks() {
        return NodePredicate.allLinks((Predicate<? super MutableModelNode>)Predicates.alwaysTrue());
    }

    public static NodePredicate allLinks(Predicate<? super MutableModelNode> predicate) {
        return new NodePredicate((Predicate)predicate){

            @Override
            protected ModelSpec scope(ModelPath scope, Predicate<? super MutableModelNode> matcher) {
                return new BasicPredicate(null, scope, null, matcher);
            }
        };
    }

    public static NodePredicate allDescendants() {
        return NodePredicate.allDescendants((Predicate<? super MutableModelNode>)Predicates.alwaysTrue());
    }

    public static NodePredicate allDescendants(Predicate<? super MutableModelNode> predicate) {
        return new NodePredicate((Predicate)predicate){

            @Override
            protected ModelSpec scope(ModelPath scope, Predicate<? super MutableModelNode> matcher) {
                return new BasicPredicate(null, null, scope, matcher);
            }
        };
    }

    public NodePredicate withType(Class<?> type) {
        return this.withType(ModelType.of(type));
    }

    public NodePredicate withType(ModelType<?> type) {
        Predicate<MutableModelNode> matcher = ModelNodes.withType(type, this.matcher);
        final NodePredicate parent = this;
        return new NodePredicate(matcher){

            @Override
            protected ModelSpec scope(ModelPath scope, Predicate<? super MutableModelNode> matcher) {
                return parent.scope(scope, matcher);
            }
        };
    }

    private static class BasicPredicate
    extends ModelSpec {
        private final ModelPath path;
        private final ModelPath parent;
        private final ModelPath ancestor;
        private final Predicate<? super MutableModelNode> matcher;

        public BasicPredicate(ModelPath path, ModelPath parent, ModelPath ancestor, Predicate<? super MutableModelNode> matcher) {
            this.path = path;
            this.parent = parent;
            this.ancestor = ancestor;
            this.matcher = matcher;
        }

        @Override
        public @Nullable ModelPath getPath() {
            return this.path;
        }

        @Override
        public @Nullable ModelPath getParent() {
            return this.parent;
        }

        @Override
        public @Nullable ModelPath getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean matches(MutableModelNode node) {
            return this.matcher.apply((Object)node);
        }
    }
}

