/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.rendering;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ProblemRenderer {
    private final PrintWriter output;

    public ProblemRenderer(Writer writer) {
        this.output = new PrintWriter(writer);
    }

    public void render(List<InternalProblem> problems) {
        ProblemRenderer.render(this.output, problems);
    }

    public void render(InternalProblem problem) {
        this.render(Collections.singletonList(problem));
    }

    private static void render(PrintWriter output, List<InternalProblem> problems) {
        Map<ProblemId, List<InternalProblem>> problemIdListMap = problems.stream().collect(Collectors.groupingBy(internalProblem -> internalProblem.getDefinition().getId()));
        String separator = "";
        for (Map.Entry<ProblemId, List<InternalProblem>> problemIdListEntry : problemIdListMap.entrySet()) {
            ProblemRenderer.renderProblemsById(output, problemIdListEntry.getKey(), problemIdListEntry.getValue(), separator);
            separator = "%n";
        }
    }

    private static void renderProblemsById(PrintWriter output, ProblemId problemId, List<InternalProblem> problems, String separator) {
        boolean isJavaCompilationProblem;
        String sep = separator;
        boolean bl = isJavaCompilationProblem = problemId.getGroup().equals(GradleCoreProblemGroup.compilation().java()) && !problemId.getName().equals("initialization-failed");
        if (isJavaCompilationProblem) {
            for (InternalProblem problem : problems) {
                output.printf(sep, new Object[0]);
                ProblemRenderer.renderJavaCompilationProblem(output, problem);
                sep = "%n";
            }
        } else {
            output.printf(sep, new Object[0]);
            sep = "%n";
            ProblemRenderer.formatMultiline(output, problemId.getDisplayName(), 0);
            for (InternalProblem problem : problems) {
                output.printf(sep, new Object[0]);
                ProblemRenderer.renderProblem(output, problem);
            }
        }
    }

    static void renderProblem(PrintWriter output, InternalProblem problem) {
        ProblemRenderer.formatMultiline(output, ProblemRenderer.getProblemLabel(problem), 1);
        if (problem.getDetails() != null) {
            output.printf("%n", new Object[0]);
            ProblemRenderer.formatMultiline(output, problem.getDetails(), 2);
        }
    }

    private static @Nullable String getProblemLabel(InternalProblem problem) {
        if (problem.getContextualLabel() != null) {
            return problem.getContextualLabel();
        }
        if (problem.getException() != null) {
            return problem.getException().getLocalizedMessage();
        }
        if (problem.getDetails() != null) {
            return "Unlabelled problem details:";
        }
        return null;
    }

    static void renderJavaCompilationProblem(PrintWriter output, InternalProblem problem) {
        ProblemRenderer.formatMultiline(output, problem.getDetails(), 0);
    }

    static void formatMultiline(PrintWriter output, @Nullable String message, int level) {
        if (message == null) {
            return;
        }
        String prefix = Strings.repeat((String)" ", (int)(level * 2));
        String formatted = TextUtil.indent((String)message, (String)prefix);
        output.print(formatted);
    }
}

