/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.BindsSoftwareFeature;
import org.gradle.api.internal.plugins.BindsSoftwareType;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.plugins.software.RegistersSoftwareTypes;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SoftwareTypeRegistrationPluginTarget
implements PluginTarget {
    private final PluginTarget delegate;
    private final SoftwareFeatureRegistry softwareFeatureRegistry;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;

    public SoftwareTypeRegistrationPluginTarget(PluginTarget delegate, SoftwareFeatureRegistry softwareFeatureRegistry, InspectionScheme inspectionScheme, InternalProblems problems) {
        this.delegate = delegate;
        this.softwareFeatureRegistry = softwareFeatureRegistry;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.delegate.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        TypeToken pluginType = TypeToken.of(plugin.getClass());
        TypeMetadata typeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(pluginType.getRawType());
        this.registerSoftwareTypes(pluginId, typeMetadata);
        this.delegate.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        this.delegate.applyRules(pluginId, clazz);
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin, Class<?> declaringClass) {
        this.delegate.applyImperativeRulesHybrid(pluginId, plugin, declaringClass);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private void registerSoftwareTypes(@Nullable String pluginId, TypeMetadata typeMetadata) {
        Optional registersSoftwareType = typeMetadata.getTypeAnnotationMetadata().getAnnotation(RegistersSoftwareTypes.class);
        registersSoftwareType.ifPresent(registration -> {
            Class registeringPlugin = (Class)Cast.uncheckedCast((Object)typeMetadata.getType());
            for (Class softwareTypeImplClass : registration.value()) {
                this.validateSoftwareTypePluginExposesExactlyOneSoftwareType(softwareTypeImplClass, typeMetadata.getType());
                this.softwareFeatureRegistry.register(pluginId, softwareTypeImplClass, registeringPlugin);
            }
        });
    }

    void validateSoftwareTypePluginExposesExactlyOneSoftwareType(Class<? extends Plugin<Project>> softwareTypePluginImplClass, Class<?> registeringPlugin) {
        boolean isBinding;
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType(softwareTypePluginImplClass, (boolean)false, (InternalProblems)this.problems);
        TypeToken softwareTypePluginImplType = TypeToken.of(softwareTypePluginImplClass);
        TypeMetadata softwareTypePluginImplMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(softwareTypePluginImplType.getRawType());
        softwareTypePluginImplMetadata.visitValidationFailures(null, (TypeValidationContext)typeValidationContext);
        List exposedSoftwareTypes = softwareTypePluginImplMetadata.getPropertiesMetadata().stream().map(propertyMetadata -> propertyMetadata.getAnnotation(SoftwareType.class)).filter(Optional::isPresent).map(annotation -> ((SoftwareType)annotation.get()).name()).sorted().collect(Collectors.toList());
        boolean bl = isBinding = softwareTypePluginImplClass.getAnnotation(BindsSoftwareType.class) != null || softwareTypePluginImplClass.getAnnotation(BindsSoftwareFeature.class) != null;
        if (!isBinding) {
            if (exposedSoftwareTypes.isEmpty()) {
                typeValidationContext.visitTypeProblem(problem -> problem.withAnnotationType(softwareTypePluginImplClass).id("missing-software-type", "Missing software type annotation", GradleCoreProblemGroup.validation().type()).contextualLabel("is registered as a software type plugin but does not expose a software type").severity(Severity.ERROR).details("This class was registered as a software type plugin, but it does not expose a software type. Software type plugins must expose exactly one software type via a property with the @SoftwareType annotation.").solution("Add @SoftwareType annotations to properties of " + softwareTypePluginImplClass.getSimpleName()).solution("Remove " + softwareTypePluginImplClass.getSimpleName() + " from the @RegistersSoftwareTypes annotation on " + registeringPlugin.getSimpleName()));
            } else if (exposedSoftwareTypes.size() > 1) {
                typeValidationContext.visitTypeProblem(problem -> problem.withAnnotationType(softwareTypePluginImplClass).id("multiple-software-types", "Multiple software type annotations", GradleCoreProblemGroup.validation().type()).contextualLabel("is registered as a software type plugin, but it exposes multiple software types").severity(Severity.ERROR).details("This class was registered as a software type plugin, but it exposes multiple software types: [" + String.join((CharSequence)", ", exposedSoftwareTypes) + "]. Software type plugins must expose exactly one software type via a property with the @SoftwareType annotation.").solution("Add the @SoftwareType annotation to only one property of " + softwareTypePluginImplClass.getSimpleName()).solution("Split " + softwareTypePluginImplClass.getSimpleName() + " into multiple plugins, each exposing a single software type and register all plugins in " + registeringPlugin.getSimpleName() + " using the @RegistersSoftwareTypes annotation"));
            }
        }
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", softwareTypePluginImplClass.getSimpleName()), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }
}

