/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class SignatureRSA
extends AbstractSignature {
    public static final NavigableSet<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableNavigableSet(Stream.of("ssh-rsa", "ssh-rsa-cert-v01@openssh.com", "rsa-sha2-256", "rsa-sha2-512", "rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-512-cert-v01@openssh.com").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
    private int verifierSignatureSize = -1;
    private final String sshAlgorithmName;

    protected SignatureRSA(String algorithm, String sshAlgorithmName) {
        super(algorithm);
        this.sshAlgorithmName = ValidateUtils.checkNotNullAndNotEmpty(sshAlgorithmName, "Missing protocol name of the signature algorithm.");
    }

    @Override
    public String getSshAlgorithmName(String algo) {
        return this.sshAlgorithmName;
    }

    protected int getVerifierSignatureSize() {
        return this.verifierSignatureSize;
    }

    @Override
    public void initVerifier(SessionContext session, PublicKey key) throws Exception {
        super.initVerifier(session, key);
        RSAKey rsaKey = ValidateUtils.checkInstanceOf(key, RSAKey.class, "Not an RSA key");
        this.verifierSignatureSize = SignatureRSA.getVerifierSignatureSize(rsaKey);
    }

    public static int getVerifierSignatureSize(RSAKey key) {
        BigInteger modulus = key.getModulus();
        return (modulus.bitLength() + 8 - 1) / 8;
    }

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        int expectedSize;
        byte[] data = sig;
        Map.Entry<String, byte[]> encoding = this.extractEncodedSignature(data, SUPPORTED_KEY_TYPES);
        if (encoding != null) {
            String keyType = encoding.getKey();
            String canonicalName = KeyUtils.getCanonicalKeyType(keyType);
            ValidateUtils.checkTrue(SUPPORTED_KEY_TYPES.contains(canonicalName), "Mismatched key type: %s", (Object)keyType);
            data = encoding.getValue();
        }
        ValidateUtils.checkTrue((expectedSize = this.getVerifierSignatureSize()) > 0, "Signature verification size has not been initialized");
        if (data.length < expectedSize) {
            byte[] pad = new byte[expectedSize];
            System.arraycopy(data, 0, pad, pad.length - data.length, data.length);
            data = pad;
        }
        return this.doVerify(data);
    }
}

