/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.UnmanagedImplStructSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.type.ModelType;

public class JavaUtilCollectionStrategy
implements ModelSchemaExtractionStrategy {
    public static final List<Class<?>> TYPES = ImmutableList.of(List.class, Set.class);

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        ModelType<T> type = extractionContext.getType();
        Class rawClass = type.getRawClass();
        List typeVariables = type.getTypeVariables();
        if (TYPES.contains(rawClass)) {
            if (typeVariables.size() > 0 && ScalarTypes.isScalarType((ModelType)typeVariables.get(0))) {
                extractionContext.found(this.createSchema(extractionContext, type, (ModelType)typeVariables.get(0)));
            } else {
                extractionContext.found(new UnmanagedImplStructSchema<T>(type, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false));
            }
        }
    }

    private <T, E> ScalarCollectionSchema<T, E> createSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<T> type, ModelType<E> elementType) {
        final ScalarCollectionSchema<T, E> schema = new ScalarCollectionSchema<T, E>(type, elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

