/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class ProjectReportTask
extends AbstractProjectBasedReportTask<ProjectReportModel> {
    private final TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Inject
    public abstract BuildStateRegistry getBuildStateRegistry();

    @Inject
    protected abstract SoftwareTypeRegistry getSoftwareTypeRegistry();

    @Override
    protected ProjectReportModel calculateReportModelFor(Project project) {
        return new ProjectReportModel(ProjectDetails.of(project), this.calculateChildrenProjectsFor(project), this.getSoftwareTypesForProject(project), project == project.getRootProject(), project.absoluteProjectPath("tasks"), project.getRootProject().absoluteProjectPath("projects"), this.calculateIncludedBuildIdentityPaths());
    }

    private List<SoftwareFeatureImplementation<?, ?>> getSoftwareTypesForProject(Project project) {
        ArrayList results = new ArrayList(1);
        this.getSoftwareTypeRegistry().getSoftwareFeatureImplementations().values().forEach(registeredType -> {
            Class softwareType = registeredType.getDefinitionPublicType();
            if (project.getExtensions().findByType(softwareType) != null) {
                results.add((SoftwareFeatureImplementation<?, ?>)registeredType);
            }
        });
        return results;
    }

    private List<ProjectReportModel> calculateChildrenProjectsFor(Project project) {
        List childProjects = CollectionUtils.sort((Iterable)ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project));
        ArrayList<ProjectReportModel> children = new ArrayList<ProjectReportModel>(childProjects.size());
        for (Project childProject : childProjects) {
            children.add(this.calculateReportModelFor(childProject));
        }
        return children;
    }

    private List<Path> calculateIncludedBuildIdentityPaths() {
        Collection includedBuilds = this.getBuildStateRegistry().getIncludedBuilds();
        ArrayList<Path> includedBuildIdentityPaths = new ArrayList<Path>(includedBuilds.size());
        for (IncludedBuildState includedBuild : includedBuilds) {
            includedBuildIdentityPaths.add(includedBuild.getIdentityPath());
        }
        return includedBuildIdentityPaths;
    }

    private void renderSectionTitle(String sectionName, StyledTextOutput textOutput) {
        textOutput.println();
        textOutput.withStyle(StyledTextOutput.Style.Header).append((CharSequence)sectionName).append((CharSequence)":");
        textOutput.println();
    }

    @Override
    protected void generateReportHeaderFor(Map<ProjectDetails, ProjectReportModel> modelsByProjectDetails) {
        this.renderSoftwareTypeInfo(modelsByProjectDetails);
        this.renderSectionTitle("Projects", this.getRenderer().getTextOutput());
    }

    private void renderSoftwareTypeInfo(Map<ProjectDetails, ProjectReportModel> modelsByProjectDetails) {
        List<SoftwareFeatureImplementation> softwareTypes = modelsByProjectDetails.values().stream().flatMap(model -> ((ProjectReportModel)model).getAllSoftwareTypes().stream()).sorted(Comparator.comparing(SoftwareFeatureImplementation::getFeatureName)).collect(Collectors.toList());
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        if (!softwareTypes.isEmpty()) {
            this.renderSectionTitle("Available software types", textOutput);
            textOutput.println();
            softwareTypes.forEach(type -> {
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)type.getFeatureName());
                textOutput.append((CharSequence)" (").append((CharSequence)type.getDefinitionPublicType().getName()).append((CharSequence)")").println();
                textOutput.append((CharSequence)"        ").append((CharSequence)"Defined in: ").append((CharSequence)type.getPluginClass().getName()).println();
                textOutput.append((CharSequence)"        ").append((CharSequence)"Registered by: ").append((CharSequence)type.getRegisteringPluginClass().getName()).println();
            });
        }
    }

    @Override
    protected void generateReportFor(ProjectDetails project, ProjectReportModel model) {
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.renderRootProjectLocation(model, textOutput);
        this.renderRootProjectDescription(model, textOutput);
        this.renderProjectHierarchy(model, textOutput);
        this.renderProjectsLocations(model, textOutput);
        this.renderIncludedBuilds(model, textOutput);
        this.renderHelp(model, textOutput);
    }

    private void renderRootProjectLocation(ProjectReportModel model, StyledTextOutput textOutput) {
        String projectDir = model.project.getAbsoluteProjectDir();
        textOutput.withStyle(StyledTextOutput.Style.Info).append((CharSequence)"Location: ");
        textOutput.withStyle(StyledTextOutput.Style.Description).append((CharSequence)projectDir);
        textOutput.println();
    }

    private void renderRootProjectDescription(ProjectReportModel model, StyledTextOutput textOutput) {
        String description = model.project.getDescription();
        if (description != null && !description.isEmpty()) {
            description = description.trim();
            textOutput.withStyle(StyledTextOutput.Style.Info).append((CharSequence)"Description: ");
            textOutput.withStyle(StyledTextOutput.Style.Description).append((CharSequence)description);
            textOutput.println();
        }
    }

    private void renderProjectHierarchy(ProjectReportModel model, StyledTextOutput textOutput) {
        this.renderSectionTitle("Project hierarchy", textOutput);
        textOutput.println();
        this.renderProject(model, new GraphRenderer(textOutput), true);
        if (model.children.isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text((Object)"No sub-projects");
            textOutput.println();
        }
    }

    private void renderProject(ProjectReportModel model, GraphRenderer renderer, boolean lastChild) {
        renderer.visit(textOutput -> {
            textOutput.text((Object)StringUtils.capitalize((String)model.project.getDisplayName()));
            this.renderProjectType(model);
            if (!model.isRootProject) {
                this.renderProjectDescription(model, (StyledTextOutput)textOutput);
            }
        }, lastChild);
        renderer.startChildren();
        Iterator iterator = model.children.iterator();
        while (iterator.hasNext()) {
            ProjectReportModel child;
            this.renderProject(child, renderer, (child = (ProjectReportModel)iterator.next()) == model.children.get(model.children.size() - 1));
        }
        renderer.completeChildren();
    }

    private void renderProjectDescription(ProjectReportModel model, StyledTextOutput textOutput) {
        String description = model.project.getDescription();
        if (description != null && !description.isEmpty()) {
            int newlineInDescription = (description = description.trim()).indexOf(10);
            if (newlineInDescription > 0) {
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description.substring(0, newlineInDescription) + "..."));
            } else {
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)(" - " + description));
            }
        }
    }

    private void renderProjectType(ProjectReportModel model) {
        if (!model.softwareTypes.isEmpty()) {
            StyledTextOutput textOutput = this.getRenderer().getTextOutput();
            assert (model.softwareTypes.size() == 1);
            textOutput.append((CharSequence)" (").append((CharSequence)((SoftwareFeatureImplementation)model.softwareTypes.get(0)).getFeatureName()).append((CharSequence)")");
        }
    }

    private void renderProjectsLocations(ProjectReportModel model, StyledTextOutput textOutput) {
        ArrayList<ProjectDetails> projectLocations = new ArrayList<ProjectDetails>(model.children.size());
        this.gatherLocations(model, projectLocations);
        if (!projectLocations.isEmpty()) {
            this.renderSectionTitle("Project locations", textOutput);
            textOutput.println();
            projectLocations.sort(Comparator.comparing(ProjectDetails::getDisplayName));
            for (ProjectDetails project : projectLocations) {
                textOutput.withStyle(StyledTextOutput.Style.Identifier).text((Object)project.getDisplayName());
                textOutput.withStyle(StyledTextOutput.Style.Description).text((Object)" - ").text((Object)Character.valueOf(File.separatorChar)).text((Object)project.getRelativeProjectDir());
                textOutput.println();
            }
        }
    }

    private void gatherLocations(ProjectReportModel model, List<ProjectDetails> locations) {
        if (!model.isRootProject) {
            locations.add(model.project);
        }
        for (ProjectReportModel child : model.children) {
            this.gatherLocations(child, locations);
        }
    }

    private void renderIncludedBuilds(ProjectReportModel model, StyledTextOutput textOutput) {
        if (model.isRootProject) {
            int index = 0;
            if (!model.includedBuildIdentityPaths.isEmpty()) {
                GraphRenderer renderer = new GraphRenderer(textOutput);
                this.renderSectionTitle("Included builds", textOutput);
                textOutput.println();
                renderer.startChildren();
                for (Path includedBuildIdentityPath : model.includedBuildIdentityPaths) {
                    renderer.visit(text -> textOutput.text((Object)("Included build '" + includedBuildIdentityPath + "'")), index + 1 == model.includedBuildIdentityPaths.size());
                    ++index;
                }
                renderer.completeChildren();
            }
        }
    }

    private void renderHelp(ProjectReportModel model, StyledTextOutput textOutput) {
        BuildClientMetaData metaData = this.getClientMetaData();
        textOutput.println();
        textOutput.text((Object)"To see a list of the tasks of a project, run ");
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{"<project-path>:tasks"});
        textOutput.println();
        textOutput.text((Object)"For example, try running ");
        ProjectReportModel exampleProject = model.children.isEmpty() ? model : (ProjectReportModel)model.children.get(0);
        metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{exampleProject.tasksTaskPath});
        textOutput.println();
        if (!model.isRootProject) {
            textOutput.println();
            textOutput.text((Object)"To see a list of all the projects in this build, run ");
            metaData.describeCommand((Appendable)textOutput.withStyle(StyledTextOutput.Style.UserInput), new String[]{model.rootProjectProjectsTaskPath});
            textOutput.println();
        }
    }

    @Incubating
    public static final class ProjectReportModel {
        private final ProjectDetails project;
        private final List<ProjectReportModel> children;
        private final List<SoftwareFeatureImplementation<?, ?>> softwareTypes;
        private final boolean isRootProject;
        private final String tasksTaskPath;
        private final String rootProjectProjectsTaskPath;
        private final List<Path> includedBuildIdentityPaths;

        private ProjectReportModel(ProjectDetails project, List<ProjectReportModel> children, List<SoftwareFeatureImplementation<?, ?>> softwareTypes, boolean isRootProject, String tasksTaskPath, String rootProjectProjectsTaskPath, List<Path> includedBuildIdentityPaths) {
            this.project = project;
            this.children = children;
            this.softwareTypes = softwareTypes;
            this.isRootProject = isRootProject;
            this.tasksTaskPath = tasksTaskPath;
            this.rootProjectProjectsTaskPath = rootProjectProjectsTaskPath;
            this.includedBuildIdentityPaths = includedBuildIdentityPaths;
        }

        private Set<SoftwareFeatureImplementation<?, ?>> getAllSoftwareTypes() {
            HashSet allSoftwareTypes = new HashSet(this.softwareTypes);
            this.children.forEach(p -> allSoftwareTypes.addAll(p.getAllSoftwareTypes()));
            return allSoftwareTypes;
        }
    }
}

