/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.Cast;
import org.gradle.util.Path;

public class DefaultProjectPublicationRegistry
implements ProjectPublicationRegistry,
HoldsProjectState {
    private final SetMultimap<Path, ProjectPublication> publicationsByProjectId = LinkedHashMultimap.create();
    private final SetMultimap<BuildIdentifier, ProjectPublicationRegistry.PublicationForProject<?>> publicationsByBuildId = LinkedHashMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ProjectPublication> Collection<T> getPublicationsForProject(Class<T> type, Path projectIdentityPath) {
        SetMultimap<Path, ProjectPublication> setMultimap = this.publicationsByProjectId;
        synchronized (setMultimap) {
            Set projectPublications = this.publicationsByProjectId.get((Object)projectIdentityPath);
            if (projectPublications.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ProjectPublication> result = new ArrayList<ProjectPublication>(projectPublications.size());
            for (ProjectPublication publication : projectPublications) {
                if (!type.isInstance(publication)) continue;
                result.add((ProjectPublication)type.cast(publication));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ProjectPublication> Collection<ProjectPublicationRegistry.PublicationForProject<T>> getPublicationsForBuild(Class<T> type, BuildIdentifier buildIdentity) {
        SetMultimap<BuildIdentifier, ProjectPublicationRegistry.PublicationForProject<?>> setMultimap = this.publicationsByBuildId;
        synchronized (setMultimap) {
            Set buildPublications = this.publicationsByBuildId.get((Object)buildIdentity);
            if (buildPublications.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ProjectPublicationRegistry.PublicationForProject<T>> result = new ArrayList<ProjectPublicationRegistry.PublicationForProject<T>>(buildPublications.size());
            for (ProjectPublicationRegistry.PublicationForProject reference : buildPublications) {
                if (!type.isInstance(reference.getPublication())) continue;
                result.add((ProjectPublicationRegistry.PublicationForProject)Cast.uncheckedCast((Object)reference));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublication(ProjectIdentity projectIdentity, ProjectPublication publication) {
        Object object = this.publicationsByProjectId;
        synchronized (object) {
            this.publicationsByProjectId.put((Object)projectIdentity.getBuildTreePath(), (Object)publication);
        }
        object = this.publicationsByBuildId;
        synchronized (object) {
            DefaultPublicationForProject publicationReference = new DefaultPublicationForProject(publication, projectIdentity);
            this.publicationsByBuildId.put((Object)new DefaultBuildIdentifier(projectIdentity.getBuildPath()), (Object)publicationReference);
        }
    }

    public void discardAll() {
        this.publicationsByProjectId.clear();
        this.publicationsByBuildId.clear();
    }

    private static class DefaultPublicationForProject
    implements ProjectPublicationRegistry.PublicationForProject<ProjectPublication> {
        private final ProjectPublication publication;
        private final ProjectIdentity projectId;

        DefaultPublicationForProject(ProjectPublication publication, ProjectIdentity projectId) {
            this.publication = publication;
            this.projectId = projectId;
        }

        @Override
        public ProjectPublication getPublication() {
            return this.publication;
        }

        @Override
        public ProjectIdentity getProducingProjectId() {
            return this.projectId;
        }
    }
}

