/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.component.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.component.DefaultAdhocSoftwareComponent;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;

public abstract class DefaultJvmSoftwareComponent
extends DefaultAdhocSoftwareComponent
implements JvmSoftwareComponentInternal {
    private final ConfigurationContainer configurations;

    @Inject
    public DefaultJvmSoftwareComponent(String componentName, ObjectFactory objectFactory, ConfigurationContainer configurations) {
        super(componentName, objectFactory);
        this.configurations = configurations;
    }

    public void withJavadocJar() {
        this.getFeatures().all(feature -> {
            if (feature.getName().equals("main")) {
                NamedDomainObjectProvider javadocElements = feature.maybeRegisterJavadocElements();
                this.addVariantsFromConfiguration((Provider)javadocElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
        });
    }

    public void withSourcesJar() {
        this.getFeatures().all(feature -> {
            if (feature.getName().equals("main")) {
                NamedDomainObjectProvider sourcesElements = feature.maybeRegisterSourcesElements();
                this.addVariantsFromConfiguration((Provider)sourcesElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
        });
    }

    public JvmFeatureInternal getMainFeature() {
        JvmFeatureInternal mainFeature = (JvmFeatureInternal)this.getFeatures().findByName("main");
        if (mainFeature == null) {
            throw new IllegalStateException("Expected to find a feature named 'main' but found none.");
        }
        return mainFeature;
    }

    public void useCompileClasspathConsistency() {
        this.getTestSuites().withType(JvmTestSuite.class).configureEach(testSuite -> this.configurations.getByName(testSuite.getSources().getCompileClasspathConfigurationName()).shouldResolveConsistentlyWith(this.getMainFeature().getCompileClasspathConfiguration()));
    }

    public void useRuntimeClasspathConsistency() {
        this.getTestSuites().withType(JvmTestSuite.class).configureEach(testSuite -> this.configurations.getByName(testSuite.getSources().getRuntimeClasspathConfigurationName()).shouldResolveConsistentlyWith(this.getMainFeature().getRuntimeClasspathConfiguration()));
    }
}

