/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.ConfigurationServicesBundle;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ResolveExceptionMapper;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.DefaultConsumableConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultDependencyScopeConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultLegacyConfiguration;
import org.gradle.api.internal.artifacts.configurations.DefaultResolvableConfiguration;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactNotationParserFactory;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.Factory;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.NotationParser;

@ServiceScope(value={Scope.Project.class})
@ThreadSafe
public class DefaultConfigurationFactory {
    private final ConfigurationServicesBundle configurationServices;
    private final ListenerManager listenerManager;
    private final DomainObjectContext domainObjectContext;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ResolveExceptionMapper exceptionContextualizer;
    private final AttributeDesugaring attributeDesugaring;
    private final UserCodeApplicationContext userCodeApplicationContext;

    @Inject
    public DefaultConfigurationFactory(ConfigurationServicesBundle configurationServices, ListenerManager listenerManager, DomainObjectContext domainObjectContext, PublishArtifactNotationParserFactory artifactNotationParserFactory, ResolveExceptionMapper exceptionMapper, AttributeDesugaring attributeDesugaring, UserCodeApplicationContext userCodeApplicationContext) {
        this.configurationServices = configurationServices;
        this.listenerManager = listenerManager;
        this.domainObjectContext = domainObjectContext;
        this.artifactNotationParser = artifactNotationParserFactory.create();
        this.capabilityNotationParser = new CapabilityNotationParserFactory(true).create();
        this.exceptionContextualizer = exceptionMapper;
        this.attributeDesugaring = attributeDesugaring;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    DefaultLegacyConfiguration create(String name, boolean isDetached, ConfigurationResolver resolver, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, ConfigurationRole role) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        return (DefaultLegacyConfiguration)this.configurationServices.getObjectFactory().newInstance(DefaultLegacyConfiguration.class, new Object[]{this.configurationServices, this.domainObjectContext, name, isDetached, resolver, dependencyResolutionListeners, resolutionStrategyFactory, this.artifactNotationParser, this.capabilityNotationParser, this.exceptionContextualizer, this.attributeDesugaring, this.userCodeApplicationContext, this, role});
    }

    DefaultResolvableConfiguration createResolvable(String name, ConfigurationResolver resolver, Factory<ResolutionStrategyInternal> resolutionStrategyFactory) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        return (DefaultResolvableConfiguration)this.configurationServices.getObjectFactory().newInstance(DefaultResolvableConfiguration.class, new Object[]{this.configurationServices, this.domainObjectContext, name, resolver, dependencyResolutionListeners, resolutionStrategyFactory, this.artifactNotationParser, this.capabilityNotationParser, this.exceptionContextualizer, this.attributeDesugaring, this.userCodeApplicationContext, this});
    }

    DefaultConsumableConfiguration createConsumable(String name, ConfigurationResolver resolver, Factory<ResolutionStrategyInternal> resolutionStrategyFactory) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        return (DefaultConsumableConfiguration)this.configurationServices.getObjectFactory().newInstance(DefaultConsumableConfiguration.class, new Object[]{this.configurationServices, this.domainObjectContext, name, resolver, dependencyResolutionListeners, resolutionStrategyFactory, this.artifactNotationParser, this.capabilityNotationParser, this.exceptionContextualizer, this.attributeDesugaring, this.userCodeApplicationContext, this});
    }

    DefaultDependencyScopeConfiguration createDependencyScope(String name, ConfigurationResolver resolver, Factory<ResolutionStrategyInternal> resolutionStrategyFactory) {
        AnonymousListenerBroadcast dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        return (DefaultDependencyScopeConfiguration)this.configurationServices.getObjectFactory().newInstance(DefaultDependencyScopeConfiguration.class, new Object[]{this.configurationServices, this.domainObjectContext, name, resolver, dependencyResolutionListeners, resolutionStrategyFactory, this.artifactNotationParser, this.capabilityNotationParser, this.exceptionContextualizer, this.attributeDesugaring, this.userCodeApplicationContext, this});
    }
}

