/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AppendOnceList;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.jspecify.annotations.Nullable;

abstract class AbstractCollectingSupplier<COLLECTOR extends ValueSupplier, TYPE>
extends AbstractMinimalProvider<TYPE> {
    protected final AppendOnceList<COLLECTOR> collectors;

    public AbstractCollectingSupplier(AppendOnceList<COLLECTOR> collectors) {
        this.collectors = collectors;
    }

    @Override
    public final ValueSupplier.Value<? extends TYPE> calculateValue(ValueSupplier.ValueConsumer consumer) {
        return super.calculateValue(consumer);
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new ValueSupplier.ValueProducer(){

            @Override
            public void visitProducerTasks(Action<? super Task> visitor) {
                AbstractCollectingSupplier.this.getProducers().forEach(c -> c.visitProducerTasks(visitor));
            }

            @Override
            public boolean isKnown() {
                return AbstractCollectingSupplier.this.getProducers().anyMatch(ValueSupplier.ValueProducer::isKnown);
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                AbstractCollectingSupplier.this.getProducers().forEach(c -> c.visitDependencies(context));
            }

            @Override
            public void visitContentProducerTasks(Action<? super Task> visitor) {
                AbstractCollectingSupplier.this.getProducers().forEach(c -> c.visitContentProducerTasks(visitor));
            }
        };
    }

    @Override
    public final boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        for (ValueSupplier collector : this.collectors) {
            if (collector.calculatePresence(consumer)) continue;
            return false;
        }
        return true;
    }

    protected <ENTRIES, BUILDER> ValueSupplier.Value<ENTRIES> calculateValue(BiFunction<BUILDER, COLLECTOR, ValueSupplier.Value<Void>> collectEntriesForCollector, BUILDER builder, Function<BUILDER, ENTRIES> buildEntries) {
        ValueSupplier.SideEffectBuilder sideEffects = ValueSupplier.SideEffect.builder();
        for (ValueSupplier collector : this.collectors) {
            ValueSupplier.Value<Void> result = collectEntriesForCollector.apply(builder, collector);
            if (result.isMissing()) {
                return result.asType();
            }
            sideEffects.add(ValueSupplier.SideEffect.fixedFrom(result));
        }
        return ValueSupplier.Value.of(buildEntries.apply(builder)).withSideEffect(sideEffects.build());
    }

    protected ValueSupplier.ExecutionTimeValue<? extends TYPE> calculateExecutionTimeValue(Function<COLLECTOR, ValueSupplier.ExecutionTimeValue<? extends TYPE>> calculateExecutionTimeValueForCollector, BiFunction<List<ValueSupplier.ExecutionTimeValue<? extends TYPE>>, ValueSupplier.SideEffectBuilder<TYPE>, ValueSupplier.ExecutionTimeValue<? extends TYPE>> calculateFixedExecutionTimeValue, Function<List<ValueSupplier.ExecutionTimeValue<? extends TYPE>>, ValueSupplier.ExecutionTimeValue<? extends TYPE>> calculateChangingExecutionTimeValue) {
        List<ValueSupplier.ExecutionTimeValue<TYPE>> executionTimeValues = this.collectExecutionTimeValues(calculateExecutionTimeValueForCollector);
        if (executionTimeValues.isEmpty()) {
            return ValueSupplier.ExecutionTimeValue.missing();
        }
        ValueSupplier.ExecutionTimeValue<? extends TYPE> fixedOrMissing = this.fixedOrMissingValueOf(executionTimeValues, calculateFixedExecutionTimeValue);
        if (fixedOrMissing != null) {
            return fixedOrMissing;
        }
        return calculateChangingExecutionTimeValue.apply(executionTimeValues);
    }

    protected List<ValueSupplier.ExecutionTimeValue<? extends TYPE>> collectExecutionTimeValues(Function<COLLECTOR, ValueSupplier.ExecutionTimeValue<? extends TYPE>> calculateExecutionTimeValueForCollector) {
        ImmutableList.Builder executionTimeValues = ImmutableList.builderWithExpectedSize((int)this.collectors.size());
        for (ValueSupplier collector : this.collectors) {
            ValueSupplier.ExecutionTimeValue<TYPE> result = calculateExecutionTimeValueForCollector.apply(collector);
            if (result.isMissing()) {
                return ImmutableList.of();
            }
            executionTimeValues.add(result);
        }
        return executionTimeValues.build();
    }

    @Override
    protected String toStringNoReentrance() {
        StringBuilder sb = new StringBuilder();
        this.collectors.forEach(collector -> {
            if (sb.length() > 0) {
                sb.append(" + ");
            }
            sb.append(collector.toString());
        });
        return sb.toString();
    }

    private @Nullable ValueSupplier.ExecutionTimeValue<? extends TYPE> fixedOrMissingValueOf(List<ValueSupplier.ExecutionTimeValue<? extends TYPE>> values, BiFunction<List<ValueSupplier.ExecutionTimeValue<? extends TYPE>>, ValueSupplier.SideEffectBuilder<TYPE>, ValueSupplier.ExecutionTimeValue<? extends TYPE>> calculateFixedExecutionTimeValue) {
        boolean fixed = true;
        boolean changingContent = false;
        for (ValueSupplier.ExecutionTimeValue<TYPE> value : values) {
            if (value.isMissing()) {
                return ValueSupplier.ExecutionTimeValue.missing();
            }
            if (value.isChangingValue()) {
                fixed = false;
                continue;
            }
            if (!value.hasChangingContent()) continue;
            changingContent = true;
        }
        if (fixed) {
            ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
            ValueSupplier.ExecutionTimeValue<TYPE> fixedValue = calculateFixedExecutionTimeValue.apply(values, sideEffectBuilder);
            fixedValue = changingContent ? fixedValue.withChangingContent() : fixedValue;
            return fixedValue.withSideEffect(sideEffectBuilder.build());
        }
        return null;
    }

    private Stream<ValueSupplier.ValueProducer> getProducers() {
        return this.collectors.stream().map(ValueSupplier::getProducer);
    }
}

